/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.client.renderer.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.userofbricks.expandedcombat.ExpandedCombat;
import com.userofbricks.expandedcombat.item.ECItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fmllegacy.RegistryObject;

public class SpecialItemModels {
    private static final String HANDHELD = "_handheld";
    private static List<Item> specialHandheldItems = new ArrayList<Item>();

    public static void detectSpecials() {
        specialHandheldItems.clear();
        for (RegistryObject ro : ECItems.ITEMS.getEntries()) {
            Item item = (Item)ro.get();
            ResourceLocation handheldModel = new ResourceLocation("expanded_combat", "models/item/" + item.getRegistryName().m_135815_() + "_handheld.json");
            if (!ExpandedCombat.modResourceExists(PackType.CLIENT_RESOURCES, handheldModel)) continue;
            SpecialItemModels.addSpecialHandheld(item);
        }
    }

    public static void addSpecialHandheld(Item item) {
        specialHandheldItems.add(item);
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(item.getRegistryName() + HANDHELD, "inventory"));
    }

    public static void onModelBake(ModelBakeEvent event) {
        Map map = event.getModelRegistry();
        for (Item item : specialHandheldItems) {
            ResourceLocation itemRes = item.getRegistryName();
            ModelResourceLocation modelName = new ModelResourceLocation(itemRes, "inventory");
            ModelResourceLocation handheldModelName = new ModelResourceLocation(itemRes + HANDHELD, "inventory");
            final BakedModel defaultModel = (BakedModel)map.get(modelName);
            final BakedModel handheldModel = (BakedModel)map.get(handheldModelName);
            if (defaultModel == null || handheldModel == null) continue;
            BakedModel wrapperModel = new BakedModel(){

                public List<BakedQuad> m_6840_(BlockState state, Direction side, Random rand) {
                    return defaultModel.m_6840_(state, side, rand);
                }

                public boolean m_7541_() {
                    return defaultModel.m_7541_();
                }

                public boolean m_7539_() {
                    return defaultModel.m_7539_();
                }

                public boolean m_7547_() {
                    return defaultModel.m_7547_();
                }

                public boolean m_7521_() {
                    return defaultModel.m_7521_();
                }

                public TextureAtlasSprite m_6160_() {
                    return defaultModel.m_6160_();
                }

                public ItemOverrides m_7343_() {
                    return handheldModel.m_7343_();
                }

                public BakedModel handlePerspective(ItemTransforms.TransformType transformType, PoseStack mat) {
                    BakedModel modelToUse = defaultModel;
                    if (transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                        modelToUse = handheldModel;
                    }
                    return ForgeHooksClient.handlePerspective((BakedModel)modelToUse, (ItemTransforms.TransformType)transformType, (PoseStack)mat);
                }
            };
            map.put(modelName, wrapperModel);
        }
    }
}

