/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.config;

import com.electronwill.nightconfig.core.EnumGetMethod;
import com.userofbricks.expandedcombat.client.renderer.gui.AlignmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.client.CuriosClientConfig;

public class ECClientConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    private static final String CONFIG_PREFIX = "config.expanded_combat.client.";

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue buttonXOffset;
        public final ForgeConfigSpec.IntValue buttonYOffset;
        public final ForgeConfigSpec.EnumValue<CuriosClientConfig.Client.ButtonCorner> buttonCorner;
        public final ForgeConfigSpec.EnumValue<AlignmentHelper.Alignment> quiverHudAnchor;
        public final ForgeConfigSpec.IntValue quiverHudOffsetX;
        public final ForgeConfigSpec.IntValue quiverHudOffsetY;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings, mostly things related to rendering").push("client");
            this.buttonXOffset = builder.comment("The X-Offset for the Quiver GUI button").translation("config.expanded_combat.client.buttonXOffset").defineInRange("buttonXOffset", 0, -100, 100);
            this.buttonYOffset = builder.comment("The Y-Offset for the Quiver GUI button").translation("config.expanded_combat.client.buttonYOffset").defineInRange("buttonYOffset", 0, -100, 100);
            this.buttonCorner = builder.comment("The corner for the Quiver GUI button").translation("config.expanded_combat.client.buttonCorner").defineEnum("buttonCorner", (Enum)CuriosClientConfig.Client.ButtonCorner.TOP_RIGHT);
            this.quiverHudAnchor = builder.comment("Sets where the Quiver HUD Element should be anchored").translation("config.expanded_combat.client.quiver_hud_anchor").defineEnum("quiver_hud_alignment", (Enum)AlignmentHelper.Alignment.BOTTOM_CENTER, EnumGetMethod.NAME_IGNORECASE);
            this.quiverHudOffsetX = builder.comment("Sets the Quiver HUD element X-axis off-set should be from it's anchor point").translation("config.expanded_combat.client.quiver_hud_offset_x").defineInRange("quiver_hud_offset_x", -139, -400, 400);
            this.quiverHudOffsetY = builder.comment("Sets the Quiver HUD element Y-axis off-set should be from it's anchor point").translation("config.expanded_combat.client.quiver_hud_offset_y").defineInRange("quiver_hud_offset_y", 63, -400, 400);
            builder.pop();
        }
    }
}

