/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.entity.projectile;

import com.google.common.collect.Sets;
import com.userofbricks.expandedcombat.entity.ECEntities;
import com.userofbricks.expandedcombat.item.ArrowType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ECArrowEntity
extends AbstractArrow {
    private static final int EXPOSED_POTION_DECAY_TIME = 600;
    private static final int NO_EFFECT_COLOR = -1;
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(Arrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Potion potion = Potions.f_43598_;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();
    private boolean fixedColor;
    private ArrowType arrowType;

    public ECArrowEntity(EntityType<? extends ECArrowEntity> p_i50172_1_, Level p_i50172_2_) {
        super(p_i50172_1_, p_i50172_2_);
        this.potion = Potions.f_43598_;
        this.arrowType = ArrowType.IRON;
    }

    public ECArrowEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ECEntities.EC_ARROW_ENTITY.get(), x, y, z, worldIn);
        this.potion = Potions.f_43598_;
        this.arrowType = ArrowType.IRON;
    }

    public ECArrowEntity(Level worldIn, LivingEntity shooter) {
        super((EntityType)ECEntities.EC_ARROW_ENTITY.get(), shooter, worldIn);
        this.potion = Potions.f_43598_;
        this.arrowType = ArrowType.IRON;
    }

    public void setEffectsFromItem(ItemStack stack) {
        if (stack.m_150930_(this.arrowType.getTippedArrow())) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)stack);
            List collection = PotionUtils.m_43571_((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : collection) {
                    this.effects.add(new MobEffectInstance(mobeffectinstance));
                }
            }
            if ((i = ECArrowEntity.getCustomColor(stack)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (stack.m_150930_(this.arrowType.getArrow())) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack p_36885_) {
        CompoundTag compoundtag = p_36885_.m_41783_();
        return compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99) ? compoundtag.m_128451_("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance p_36871_) {
        this.effects.add(p_36871_);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.effects.isEmpty() && this.f_36704_ >= 600) {
            this.f_19853_.m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void makeParticle(int p_36877_) {
        int i = this.getColor();
        if (i != -1 && p_36877_ > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < p_36877_; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int p_191507_1_) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)p_191507_1_);
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.potion != Potions.f_43598_ && this.potion != null) {
            compound.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("CustomPotionEffects", (Tag)listnbt);
        }
        CompoundTag arrowTypenbt = new CompoundTag();
        compound.m_128359_("ArrowType", this.arrowType.name());
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)compound);
        }
        for (MobEffectInstance effectinstance : PotionUtils.m_43573_((CompoundTag)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.m_128425_("Color", 99)) {
            this.setFixedColor(compound.m_128451_("Color"));
        } else {
            this.updateColor();
        }
        if (compound.m_128441_("ArrowType")) {
            String type = compound.m_128461_("ArrowType");
            this.arrowType = ArrowType.valueOf(type);
        }
    }

    protected void m_7761_(LivingEntity livingEntity) {
        super.m_7761_(livingEntity);
        Entity entity = this.m_150173_();
        for (MobEffectInstance mobeffectinstance : this.potion.m_43488_()) {
            livingEntity.m_147207_(new MobEffectInstance(mobeffectinstance.m_19544_(), Math.max(mobeffectinstance.m_19557_() / 8, 1), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance mobeffectinstance1 : this.effects) {
                livingEntity.m_147207_(mobeffectinstance1, entity);
            }
        }
    }

    @Nonnull
    protected ItemStack m_7941_() {
        if (this.effects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)this.arrowType.getArrow());
        }
        ItemStack itemstack = new ItemStack((ItemLike)this.arrowType.getTippedArrow());
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    public void m_7822_(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public void setArrowType(ArrowType arrowType) {
        this.arrowType = arrowType;
    }
}

