/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.userofbricks.expandedcombat.ExpandedCombat;
import com.userofbricks.expandedcombat.client.KeyRegistry;
import com.userofbricks.expandedcombat.client.renderer.gui.screen.inventory.ECCuriosQuiverScreen;
import com.userofbricks.expandedcombat.client.renderer.gui.screen.inventory.QuiverButton;
import com.userofbricks.expandedcombat.item.ECQuiverItem;
import com.userofbricks.expandedcombat.network.NetworkHandler;
import com.userofbricks.expandedcombat.network.client.CPacketOpenCuriosQuiver;
import com.userofbricks.expandedcombat.util.QuiverUtil;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;
import top.theillusivec4.curios.client.gui.CuriosScreen;

public class QuiverEvents {
    public static final NonNullSupplier<IllegalArgumentException> CAPABILITY_EXCEPTION = () -> new IllegalArgumentException("Capability must not be null!");

    @SubscribeEvent
    public void arrowPickup(PlayerEvent.ItemPickupEvent e) {
        ItemStack toPickup = e.getOriginalEntity().m_32055_();
        Player player = e.getPlayer();
        ItemStack quiverStack = CuriosApi.getCuriosHelper().findEquippedCurio(item -> item.m_41720_() instanceof ECQuiverItem, (LivingEntity)player).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.f_41583_);
        if (toPickup.m_41720_() instanceof ArrowItem && !quiverStack.m_41619_()) {
            ItemStack arrowStack = CuriosApi.getCuriosHelper().findEquippedCurio(item -> item.m_41720_() instanceof ArrowItem, (LivingEntity)player).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.f_41583_);
            if (arrowStack.m_41720_() == toPickup.m_41720_() && arrowStack.m_41613_() < 64) {
                CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(icurioitemhandler -> {
                    ItemStack rem = toPickup.m_41777_();
                    ICurioStacksHandler iCurioStacksHandler = (ICurioStacksHandler)icurioitemhandler.getCurios().get("arrows");
                    IDynamicStackHandler iDynamicStackHandler = iCurioStacksHandler.getStacks();
                    rem = iDynamicStackHandler.insertItem(0, rem, false);
                    if (rem.m_41619_()) {
                        toPickup.m_41764_(0);
                        e.setResult(Event.Result.ALLOW);
                        e.setCanceled(true);
                    } else {
                        toPickup.m_41764_(rem.m_41613_());
                    }
                });
            } else if (arrowStack.m_41619_()) {
                System.out.println("beeple " + toPickup);
                CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(ICuriosItemHandler::getCurios).map(stringICurioStacksHandlerMap -> (ICurioStacksHandler)stringICurioStacksHandlerMap.get("arrows")).map(ICurioStacksHandler::getStacks).ifPresent(curioStackHandler -> curioStackHandler.setStackInSlot(0, toPickup.m_41777_()));
                toPickup.m_41764_(0);
                e.setResult(Event.Result.ALLOW);
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void curioRightClick(PlayerInteractEvent.RightClickItem evt) {
        Player player = evt.getPlayer();
        ItemStack stack = evt.getItemStack();
        ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
        if (ExpandedCombat.quiver_predicate.test(stack) && stack.m_41741_() > 1) {
            curiosHelper.getCurio(stack).ifPresent(curio -> curiosHelper.getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                if (!player.f_19853_.f_46443_) {
                    Map curios = handler.getCurios();
                    boolean insertedItems = false;
                    for (Map.Entry entry : curios.entrySet()) {
                        IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                        int remainingItems = stack.m_41613_();
                        for (int i = 0; i < stackHandler.getSlots(); ++i) {
                            ItemStack present;
                            String id = (String)entry.getKey();
                            SlotContext slotContext = new SlotContext(id, (LivingEntity)player, i, false, ((Boolean)((ICurioStacksHandler)entry.getValue()).getRenders().get(i)).booleanValue());
                            if (!curiosHelper.isStackValid(slotContext, stack) || !curio.canEquip(id, (LivingEntity)player) || !curio.canEquipFromUse(slotContext) || (present = stackHandler.getStackInSlot(i)).m_41619_() || stack.m_41720_() != present.m_41720_() || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)present)) continue;
                            ItemStack newStack = stack.m_41777_();
                            newStack.m_41764_(remainingItems + present.m_41613_());
                            int itemLimit = Math.min(stack.m_41741_(), stackHandler.getSlotLimit(i));
                            int count = Math.min(newStack.m_41613_(), itemLimit);
                            if (newStack.m_41613_() > itemLimit) {
                                remainingItems = newStack.m_41613_() - itemLimit;
                                newStack.m_41764_(itemLimit);
                            }
                            stackHandler.setStackInSlot(i, newStack);
                            curio.onEquipFromUse(slotContext);
                            if (!player.m_7500_()) {
                                stack.m_41774_(count);
                            }
                            if (remainingItems <= 0) {
                                evt.setCancellationResult(InteractionResult.SUCCESS);
                                evt.setCanceled(true);
                                return;
                            }
                            insertedItems = true;
                        }
                    }
                    if (insertedItems) {
                        evt.setCancellationResult(InteractionResult.SUCCESS);
                        evt.setCanceled(true);
                    }
                }
            }));
        }
    }

    public static void drawSlotBack(GuiContainerEvent.DrawBackground e) {
        if (e.getGuiContainer() instanceof CuriosScreen) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ContainerScreen.f_97725_);
            CuriosScreen curiosScreen = (CuriosScreen)e.getGuiContainer();
            int left = curiosScreen.getGuiLeft();
            int top = curiosScreen.getGuiTop();
            curiosScreen.m_93228_(e.getMatrixStack(), left + 76, top + 17, 7, 7, 18, 36);
        }
    }

    @SubscribeEvent
    public void onKeyInput(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91302_() && mc.f_91080_ == null && KeyRegistry.openQuiver.m_90857_()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketOpenCuriosQuiver());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onInventoryGuiInit(GuiScreenEvent.InitGuiEvent.Post evt) {
        Screen screen = evt.getGui();
        if (screen instanceof CuriosScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)gui.getMinecraft().f_91074_).map(ICuriosItemHandler::getCurios).map(stringICurioStacksHandlerMap -> (ICurioStacksHandler)stringICurioStacksHandlerMap.get("arrows")).ifPresent(curioStacksHandler -> {
                int slotCount = curioStacksHandler.getSlots();
                if (slotCount > 1) {
                    Tuple<Integer, Integer> offsets = ECCuriosQuiverScreen.getButtonOffset(false);
                    int x = (Integer)offsets.m_14418_();
                    int y = (Integer)offsets.m_14419_();
                    int size = 14;
                    int textureOffsetX = 194;
                    int yOffset = 83;
                    evt.addWidget((GuiEventListener)new QuiverButton(gui, gui.getGuiLeft() + x, gui.getGuiTop() + y + yOffset, size, size, textureOffsetX, 0, size, ECCuriosQuiverScreen.QUIVER_INVENTORY));
                }
            });
        }
    }

    @SubscribeEvent
    public void curioChangeToSpartanQuiver(CurioChangeEvent evt) {
        String type = evt.getIdentifier();
        if (type.equals("quiver")) {
            ItemStack toStack = evt.getTo();
            ItemStack fromStack = evt.getFrom();
            boolean isFromSpartanQuiver = QuiverUtil.isSpartanQuiver(fromStack);
            boolean isToSpartanQuiver = QuiverUtil.isSpartanQuiver(toStack);
            boolean isFromECQuiver = fromStack.m_41720_() instanceof ECQuiverItem;
            boolean isToECQuiver = toStack.m_41720_() instanceof ECQuiverItem;
            int quiverProvidedSlots = QuiverUtil.getQuiverProvidedSlots(toStack);
            LivingEntity livingEntity = evt.getEntityLiving();
            CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(ICuriosItemHandler::getCurios).map(stringICurioStacksHandlerMap -> (ICurioStacksHandler)stringICurioStacksHandlerMap.get("arrows")).map(ICurioStacksHandler::getStacks).ifPresent(curioStackHandler -> {
                for (int i = 0; i < curioStackHandler.getSlots(); ++i) {
                    ItemStack arrowStack = curioStackHandler.getStackInSlot(i);
                    if (ExpandedCombat.isSpartanWeponryLoaded && isFromSpartanQuiver) {
                        IItemHandler quiverHandler = (IItemHandler)fromStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(CAPABILITY_EXCEPTION);
                        for (int j = 0; j < quiverHandler.getSlots() && !(arrowStack = quiverHandler.insertItem(j, arrowStack, false)).m_41619_(); ++j) {
                        }
                    }
                    if (arrowStack.m_41619_() || isToECQuiver && i + 1 <= quiverProvidedSlots) continue;
                    this.dropStack(arrowStack, livingEntity);
                    curioStackHandler.setStackInSlot(i, ItemStack.f_41583_);
                }
                QuiverUtil.updateArrowSlotCount(toStack, livingEntity);
                if (ExpandedCombat.isSpartanWeponryLoaded && isToSpartanQuiver) {
                    IItemHandler quiverHandler1 = (IItemHandler)toStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(CAPABILITY_EXCEPTION);
                    for (int j = 0; j < quiverHandler1.getSlots(); ++j) {
                        ItemStack quiverArrowStack = quiverHandler1.extractItem(j, 64, false);
                        if (quiverArrowStack.m_41619_()) continue;
                        for (int i = 0; i < curioStackHandler.getSlots(); ++i) {
                            ItemStack arrowstack = curioStackHandler.getStackInSlot(i);
                            if (arrowstack.m_41720_() != quiverArrowStack.m_41720_()) continue;
                            quiverArrowStack = curioStackHandler.insertItem(i, quiverArrowStack, false);
                        }
                        if (quiverArrowStack.m_41619_()) continue;
                        this.dropStack(quiverArrowStack, livingEntity);
                    }
                    toStack.m_41784_().m_128379_("ammoCollect", false);
                }
            });
        }
    }

    public void dropStack(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            ItemHandlerHelper.giveItemToPlayer((Player)((Player)entity), (ItemStack)stack);
        } else {
            Containers.m_18992_((Level)entity.f_19853_, (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (ItemStack)stack);
        }
    }
}

