/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.inventory.container;

import com.mojang.datafixers.util.Pair;
import com.userofbricks.expandedcombat.inventory.container.ECContainers;
import com.userofbricks.expandedcombat.item.ECQuiverItem;
import com.userofbricks.expandedcombat.util.QuiverUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketScroll;
import top.theillusivec4.curios.common.network.server.SPacketScroll;

public class ECCuriosQuiverContainer
extends InventoryMenu {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public final LazyOptional<ICuriosItemHandler> curiosHandler;
    private final Player player;
    private final boolean isLocalWorld;
    private int lastScrollIndex;
    private boolean cosmeticColumn;

    public ECCuriosQuiverContainer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(windowId, playerInventory);
    }

    public ECCuriosQuiverContainer(int windowId, Inventory playerInventory) {
        super(playerInventory, playerInventory.f_35978_.f_19853_.f_46443_, playerInventory.f_35978_);
        this.f_38843_ = (MenuType)ECContainers.EC_QUIVER_CURIOS.get();
        this.f_38840_ = windowId;
        this.f_38841_.clear();
        this.f_38839_.clear();
        this.player = playerInventory.f_35978_;
        this.isLocalWorld = this.player.f_19853_.f_46443_;
        this.curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.player);
        for (int i = 0; i < 4; ++i) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[i];
            this.m_38897_(new Slot((Container)playerInventory, 36 + (3 - i), 8, 8 + i * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(@Nonnull ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)ECCuriosQuiverContainer.this.player);
                }

                public boolean m_8010_(@Nonnull Player playerIn) {
                    ItemStack itemstack = this.m_7993_();
                    return (itemstack.m_41619_() || playerIn.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(playerIn);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.m_20749_()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.m_38897_(new Slot((Container)playerInventory, 40, 77, 62){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        this.curiosHandler.ifPresent(curios -> {
            Map curioMap = curios.getCurios();
            int slots = 0;
            int yOffset = 12;
            for (String identifier : curioMap.keySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curioMap.get(identifier);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (identifier.equals("quiver") && stacksHandler.getSlots() > 0) {
                    this.m_38897_((Slot)new CurioSlot(this.player, stackHandler, 0, identifier, 77, 18, stacksHandler.getRenders()){

                        public boolean m_5857_(@Nonnull ItemStack stack) {
                            return false;
                        }

                        public boolean m_8010_(@Nonnull Player playerIn) {
                            return false;
                        }
                    });
                }
                if (identifier.equals("arrows") && stacksHandler.getSlots() > 0) {
                    int slotLeft = 98;
                    int slotTop = 18;
                    int rowCount = 0;
                    final ItemStack quiverStack = ((ICurioStacksHandler)curioMap.get("quiver")).getStacks().getStackInSlot(0).m_41777_();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        final int finalI = i;
                        this.m_38897_((Slot)new CurioSlot(this.player, stackHandler, finalI, identifier, slotLeft, slotTop, stacksHandler.getRenders()){

                            public boolean m_5857_(@Nonnull ItemStack stack) {
                                if (this.mayInteract()) {
                                    return super.m_5857_(stack);
                                }
                                return false;
                            }

                            private boolean mayInteract() {
                                if (quiverStack.m_41720_() instanceof ECQuiverItem) {
                                    return finalI + 1 <= ((ECQuiverItem)quiverStack.m_41720_()).providedSlots;
                                }
                                if (QuiverUtil.isSpartanQuiver(quiverStack)) {
                                    return finalI + 1 <= QuiverUtil.getQuiverProvidedSlots(quiverStack);
                                }
                                return false;
                            }
                        });
                        if (++rowCount == 4) {
                            slotTop += 18;
                            slotLeft = 98;
                            rowCount = 0;
                            continue;
                        }
                        slotLeft += 18;
                    }
                }
                if (!stacksHandler.isVisible() || identifier.equals("quiver")) continue;
                for (int i = 0; i < stackHandler.getSlots() && slots < 8; ++slots, ++i) {
                    this.m_38897_((Slot)new CurioSlot(this.player, stackHandler, i, identifier, -18, yOffset, stacksHandler.getRenders()));
                    if (stacksHandler.hasCosmetic()) {
                        IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                        this.cosmeticColumn = true;
                        this.m_38897_((Slot)new CosmeticCurioSlot(this.player, cosmeticHandler, i, identifier, -37, yOffset));
                    }
                    yOffset += 18;
                }
            }
        });
        this.scrollToIndex(0);
    }

    public boolean hasCosmeticColumn() {
        return this.cosmeticColumn;
    }

    public void scrollToIndex(int indexIn) {
        this.curiosHandler.ifPresent(arg_0 -> this.lambda$scrollToIndex$2(indexIn, arg_0));
    }

    public void scrollTo(float pos) {
        this.curiosHandler.ifPresent(curios -> {
            int k = curios.getVisibleSlots() - 8;
            int j = (int)((double)(pos * (float)k) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (j != this.lastScrollIndex && this.isLocalWorld) {
                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketScroll(this.f_38840_, j));
            }
        });
    }

    public void m_6199_(@Nonnull Container inventoryIn) {
    }

    public void m_6877_(@Nonnull Player player) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(ICuriosItemHandler::getCurios).map(stringICurioStacksHandlerMap -> (ICurioStacksHandler)stringICurioStacksHandlerMap.get("quiver")).map(ICurioStacksHandler::getStacks).ifPresent(curioStackHandler -> {
            ItemStack quiverStack = curioStackHandler.getStackInSlot(0).m_41777_();
            QuiverUtil.updateArrowSlotCount(quiverStack.m_41777_(), (LivingEntity)player);
        });
    }

    public boolean canScroll() {
        return this.curiosHandler.map(curios -> curios.getVisibleSlots() > 8 ? 1 : 0).orElse(0) == 1;
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int i;
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            EquipmentSlot entityequipmentslot = Mob.m_147233_((ItemStack)itemstack);
            if (index < 4 ? !this.m_38903_(itemstack1, 4, 40, false) : (entityequipmentslot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(3 - entityequipmentslot.m_20749_())).m_6657_() ? !this.m_38903_(itemstack1, i = 3 - entityequipmentslot.m_20749_(), i + 1, false) : (index < 41 && !CuriosApi.getCuriosHelper().getCurioTags(itemstack.m_41720_()).isEmpty() ? !this.m_38903_(itemstack1, 41, this.f_38839_.size(), false) : (entityequipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(41)).m_6657_() ? !this.m_38903_(itemstack1, 40, 41, false) : (index < 31 ? !this.m_38903_(itemstack1, 31, 40, false) : (index < 40 ? !this.m_38903_(itemstack1, 4, 31, false) : !this.m_38903_(itemstack1, 4, 40, false))))))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return itemstack;
    }

    @Nonnull
    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public void m_5816_(@Nonnull StackedContents itemHelperIn) {
    }

    public void m_6650_() {
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipeIn) {
        return false;
    }

    public int m_6636_() {
        return -1;
    }

    public int m_6635_() {
        return 0;
    }

    public int m_6656_() {
        return 0;
    }

    public int m_6653_() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$scrollToIndex$2(int indexIn, ICuriosItemHandler curios) {
        curioMap = curios.getCurios();
        slots = 0;
        yOffset = 12;
        index = 0;
        arrows = ((ICurioStacksHandler)curioMap.get("arrows")).getSlots();
        quiver = ((ICurioStacksHandler)curioMap.get("quiver")).getSlots();
        this.f_38839_.subList(41 + arrows + quiver, this.f_38839_.size()).clear();
        if (this.f_38841_ != null) {
            this.f_38841_.subList(41 + arrows + quiver, this.f_38841_.size()).clear();
        }
        var7 = curioMap.keySet().iterator();
        block0: while (true) {
            if (!var7.hasNext()) {
                if (!this.isLocalWorld) {
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with((Supplier<ServerPlayer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$scrollToIndex$1(), ()Lnet/minecraft/server/level/ServerPlayer;)((ECCuriosQuiverContainer)this)), (Object)new SPacketScroll(this.f_38840_, indexIn));
                }
                this.lastScrollIndex = indexIn;
                return;
            }
            identifier = (String)var7.next();
            if (identifier.equals("quiver")) {
                identifier = (String)var7.next();
            }
            stacksHandler = (ICurioStacksHandler)curioMap.get(identifier);
            stackHandler = stacksHandler.getStacks();
            if (!stacksHandler.isVisible()) continue;
            i = 0;
            while (true) {
                if (i < stackHandler.getSlots() && slots < 8) ** break;
                continue block0;
                if (index >= indexIn) {
                    this.m_38897_((Slot)new CurioSlot(this.player, stackHandler, i, identifier, -18, yOffset, stacksHandler.getRenders()));
                    if (stacksHandler.hasCosmetic()) {
                        cosmeticHandler = stacksHandler.getCosmeticStacks();
                        this.cosmeticColumn = true;
                        this.m_38897_((Slot)new CosmeticCurioSlot(this.player, cosmeticHandler, i, identifier, -37, yOffset));
                    }
                    yOffset += 18;
                    ++slots;
                }
                ++index;
                ++i;
            }
            break;
        }
    }

    private /* synthetic */ ServerPlayer lambda$scrollToIndex$1() {
        return (ServerPlayer)this.player;
    }
}

