/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ECBowItem
extends BowItem {
    private final int multishotLevel;
    private final int bowPower;
    private final float velocityMultiplyer;
    float mendingBonus;

    public ECBowItem(float mendingBonus, float velocityMultiplyer, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = 0;
        this.mendingBonus = mendingBonus;
    }

    public ECBowItem(float mendingBonus, float velocityMultiplyer, int bowPower, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = bowPower;
        this.mendingBonus = mendingBonus;
    }

    public ECBowItem(float mendingBonus, float velocityMultiplyer, int bowPower, int multishotLevel, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = multishotLevel;
        this.bowPower = bowPower;
        this.mendingBonus = mendingBonus;
    }

    public ECBowItem(float velocityMultiplyer, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = 0;
        this.mendingBonus = 0.0f;
    }

    public ECBowItem(float velocityMultiplyer, int bowPower, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = bowPower;
        this.mendingBonus = 0.0f;
    }

    public ECBowItem(float velocityMultiplyer, int bowPower, int multishotLevel, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = multishotLevel;
        this.bowPower = bowPower;
        this.mendingBonus = 0.0f;
    }

    public int getMultishotLevel() {
        return this.multishotLevel;
    }

    private int getBowPower() {
        return this.bowPower;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerentity = (Player)entityLiving;
            boolean useInfiniteAmmo = playerentity.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemstack = playerentity.m_6298_(stack);
            int charge = this.m_8105_(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)worldIn, (Player)playerentity, (int)charge, (!itemstack.m_41619_() || useInfiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || useInfiniteAmmo) {
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                float arrowVelocity = this.getBowArrowVelocity(stack, charge);
                this.fireArrows(stack, worldIn, playerentity, itemstack, arrowVelocity);
            }
        }
    }

    public void fireArrows(ItemStack stack, Level worldIn, Player playerentity, ItemStack itemstack, float arrowVelocity) {
        int multishotLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) + this.getMultishotLevel();
        int arrowsToFire = 1 + multishotLevel * 2;
        for (int arrowNumber = 0; arrowNumber < arrowsToFire; ++arrowNumber) {
            boolean isAdditionalShot;
            if (!((double)arrowVelocity >= 0.1)) continue;
            boolean hasInfiniteAmmo = playerentity.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, stack, playerentity);
            boolean bl = isAdditionalShot = arrowNumber > 0;
            if (!worldIn.f_46443_) {
                this.createBowArrow(stack, worldIn, playerentity, itemstack, arrowVelocity, arrowNumber, hasInfiniteAmmo, isAdditionalShot);
            }
            worldIn.m_6263_(null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.m_5822_().nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
            if (!(hasInfiniteAmmo || playerentity.m_150110_().f_35937_ || isAdditionalShot)) {
                itemstack.m_41774_(1);
                if (itemstack.m_41619_()) {
                    playerentity.m_150109_().m_36057_(itemstack);
                }
            }
            playerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public void createBowArrow(ItemStack stack, Level worldIn, Player playerentity, ItemStack itemstack, float arrowVelocity, int i, boolean hasInfiniteAmmo, boolean isAdditionalShot) {
        int k;
        int powerLevel;
        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
        AbstractArrow abstractarrowentity = arrowitem.m_6394_(worldIn, itemstack, (LivingEntity)playerentity);
        abstractarrowentity = this.customArrow(abstractarrowentity);
        this.setArrowTrajectory(playerentity, arrowVelocity, i, abstractarrowentity);
        if (arrowVelocity == 1.0f) {
            abstractarrowentity.m_36762_(true);
        }
        if ((powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack) + this.getBowPower()) > 0) {
            abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            abstractarrowentity.m_36735_(k);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            abstractarrowentity.m_20254_(100);
        }
        stack.m_41622_(1, (LivingEntity)playerentity, p_220009_1_ -> p_220009_1_.m_21190_(playerentity.m_7655_()));
        if (hasInfiniteAmmo || playerentity.m_150110_().f_35937_ && (itemstack.m_41720_() == Items.f_42737_ || itemstack.m_41720_() == Items.f_42738_)) {
            abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        if (isAdditionalShot) {
            abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        worldIn.m_7967_((Entity)abstractarrowentity);
    }

    public void setArrowTrajectory(Player playerentity, float arrowVelocity, int i, AbstractArrow abstractarrowentity) {
        if (i == 0) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 0.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 1) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 10.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 2) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 10.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 3) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 20.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 4) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 20.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 5) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 30.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 6) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 30.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
    }

    public float getBowArrowVelocity(ItemStack stack, int charge) {
        float bowChargeTime = this.getBowChargeTime(stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        if ((arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f) > 1.0f) {
            arrowVelocity = 1.0f;
        }
        return arrowVelocity;
    }

    public float getBowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        return Math.max(20 - 5 * quickChargeLevel, 0);
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.mendingBonus;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (this.mendingBonus != 0.0f) {
            if (this.mendingBonus > 0.0f) {
                list.add(0, (Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(this.mendingBonus))));
            } else if (this.mendingBonus < 0.0f) {
                list.add(0, (Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.RED).m_7220_((Component)new TextComponent(ChatFormatting.RED + " +" + ItemStack.f_41584_.format(this.mendingBonus))));
            }
        }
    }
}

