/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ECCrossBowItem
extends CrossbowItem {
    private int multishotLevel;
    private int bowPower;
    private final float velocityMultiplyer;
    float mendingBonus;
    public boolean f_40847_ = false;
    public boolean f_40848_ = false;

    public ECCrossBowItem(float mendingBonus, float velocityMultiplyer, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = 0;
        this.mendingBonus = mendingBonus;
    }

    public ECCrossBowItem(float mendingBonus, float velocityMultiplyer, int bowPower, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = bowPower;
        this.mendingBonus = mendingBonus;
    }

    public ECCrossBowItem(float mendingBonus, float velocityMultiplyer, int bowPower, int multishotLevel, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = multishotLevel;
        this.bowPower = bowPower;
        this.mendingBonus = mendingBonus;
    }

    public ECCrossBowItem(float velocityMultiplyer, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = 0;
        this.mendingBonus = 0.0f;
    }

    public ECCrossBowItem(float velocityMultiplyer, int bowPower, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = bowPower;
        this.mendingBonus = 0.0f;
    }

    public ECCrossBowItem(float velocityMultiplyer, int bowPower, int multishotLevel, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = multishotLevel;
        this.bowPower = bowPower;
        this.mendingBonus = 0.0f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (ECCrossBowItem.m_40932_((ItemStack)itemstack)) {
            this.fireCrossbowProjectiles(worldIn, (LivingEntity)playerIn, handIn, itemstack, this.getProjectileVelocity(itemstack), 1.0f);
            CrossbowItem.m_40884_((ItemStack)itemstack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!playerIn.m_6298_(itemstack).m_41619_()) {
            if (!ECCrossBowItem.m_40932_((ItemStack)itemstack)) {
                this.f_40847_ = false;
                this.f_40848_ = false;
                playerIn.m_6672_(handIn);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5929_(Level world, LivingEntity livingEntity, ItemStack stack, int timeLeft) {
        if (!world.f_46443_) {
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            SoundEvent quickChargeSoundEvent = this.getCrossbowSoundEvent(quickChargeLevel);
            SoundEvent loadingMiddleSoundEvent = quickChargeLevel == 0 ? SoundEvents.f_11842_ : null;
            float chargeTime = (float)(stack.m_41779_() - timeLeft) / (float)this.getCrossbowChargeTime(stack);
            if (chargeTime < 0.2f) {
                this.f_40847_ = false;
                this.f_40848_ = false;
            }
            if (chargeTime >= 0.2f && !this.f_40847_ && chargeTime < 1.0f) {
                this.f_40847_ = true;
                world.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), quickChargeSoundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (chargeTime >= 0.5f && loadingMiddleSoundEvent != null && !this.f_40848_ && chargeTime < 1.0f) {
                this.f_40848_ = true;
                world.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), loadingMiddleSoundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        float f = this.getCrossbowCharge(i, stack);
        if (f >= 1.0f && !ECCrossBowItem.m_40932_((ItemStack)stack) && this.m_40859_(entityLiving, stack)) {
            ECCrossBowItem.m_40884_((ItemStack)stack, (boolean)true);
            SoundSource soundcategory = entityLiving instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11841_, soundcategory, 1.0f, 1.0f / (worldIn.m_5822_().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getCrossbowCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)this.getCrossbowChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getCrossbowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        return Math.max(25 - 5 * quickChargeLevel, 0);
    }

    public SoundEvent getCrossbowSoundEvent(int i) {
        switch (i) {
            case 1: {
                return SoundEvents.f_11844_;
            }
            case 2: {
                return SoundEvents.f_11845_;
            }
            case 3: {
                return SoundEvents.f_11846_;
            }
        }
        return SoundEvents.f_11843_;
    }

    public void fireCrossbowProjectiles(Level world, LivingEntity livingEntity, InteractionHand hand, ItemStack stack, float velocityIn, float inaccuracyIn) {
        List<ItemStack> list = ECCrossBowItem.getChargedProjectiles(stack);
        float[] randomSoundPitches = ECCrossBowItem.getRandomSoundPitches(livingEntity.m_21187_());
        for (int i = 0; i < list.size(); ++i) {
            boolean playerInCreativeMode;
            ItemStack currentProjectile = list.get(i);
            boolean bl = playerInCreativeMode = livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_;
            if (currentProjectile.m_41619_()) continue;
            if (i == 0) {
                this.m_40894_(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 0.0f);
                continue;
            }
            if (i == 1) {
                this.m_40894_(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, -10.0f);
                continue;
            }
            if (i == 2) {
                this.m_40894_(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 10.0f);
                continue;
            }
            if (i == 3) {
                this.m_40894_(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, -20.0f);
                continue;
            }
            if (i == 4) {
                this.m_40894_(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, 20.0f);
                continue;
            }
            if (i == 5) {
                this.m_40894_(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, -30.0f);
                continue;
            }
            if (i != 6) continue;
            this.m_40894_(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, 30.0f);
        }
        ECCrossBowItem.fireProjectilesAfter(world, livingEntity, stack);
    }

    private AbstractArrow createCrossbowArrow(Level world, LivingEntity livingEntity, ItemStack stack, ItemStack stack1) {
        int punchLevel;
        int powerLevel;
        ArrowItem arrowItem = (ArrowItem)(stack1.m_41720_() instanceof ArrowItem ? stack1.m_41720_() : Items.f_42412_);
        AbstractArrow abstractArrowEntity = arrowItem.m_6394_(world, stack1, livingEntity);
        if (livingEntity instanceof Player) {
            abstractArrowEntity.m_36762_(true);
        }
        abstractArrowEntity.m_36740_(SoundEvents.f_11840_);
        abstractArrowEntity.m_36793_(true);
        int piercingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack);
        if (piercingLevel > 0) {
            abstractArrowEntity.m_36767_((byte)piercingLevel);
        }
        if ((powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack) + this.bowPower) > 0) {
            abstractArrowEntity.m_36781_(abstractArrowEntity.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack) + this.bowPower) > 0) {
            abstractArrowEntity.m_36735_(punchLevel);
        }
        return abstractArrowEntity;
    }

    public float getProjectileVelocity(ItemStack stack) {
        if (ECCrossBowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_)) {
            return 1.6f * this.velocityMultiplyer;
        }
        return 3.2f * this.velocityMultiplyer;
    }

    public int m_8105_(ItemStack stack) {
        return this.getCrossbowChargeTime(stack) + 3;
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    void m_40894_(Level worldIn, LivingEntity shooter, InteractionHand handIn, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!worldIn.f_46443_) {
            AbstractArrow projectileentity;
            boolean flag;
            boolean bl = flag = projectile.m_41720_() == Items.f_42688_;
            if (flag) {
                projectileentity = new FireworkRocketEntity(worldIn, projectile, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true);
            } else {
                projectileentity = this.createCrossbowArrow(worldIn, shooter, crossbow, projectile);
                if (isCreativeMode || projectileAngle != 0.0f) {
                    projectileentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob icrossbowuser = (CrossbowAttackMob)shooter;
                icrossbowuser.m_5811_(Objects.requireNonNull(icrossbowuser.m_5448_()), crossbow, (Projectile)projectileentity, projectileAngle);
            } else {
                Vec3 vector3d1 = shooter.m_20289_(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), projectileAngle, true);
                Vec3 vector3d2 = shooter.m_20252_(1.0f);
                Vector3f vector3f = new Vector3f(vector3d2);
                vector3f.m_122251_(quaternion);
                projectileentity.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), velocity, inaccuracy);
            }
            crossbow.m_41622_(flag ? 3 : 1, shooter, p_220017_1_ -> p_220017_1_.m_21190_(handIn));
            worldIn.m_7967_((Entity)projectileentity);
            worldIn.m_6263_((Player)null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    static void fireProjectilesAfter(Level worldIn, LivingEntity shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)shooter;
            if (!worldIn.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverplayerentity, stack);
            }
            serverplayerentity.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        }
        ECCrossBowItem.clearProjectiles(stack);
    }

    private static void clearProjectiles(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        if (compoundnbt != null) {
            ListTag listnbt = compoundnbt.m_128437_("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.m_128365_("ChargedProjectiles", (Tag)listnbt);
        }
    }

    static List<ItemStack> getChargedProjectiles(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundnbt = stack.m_41783_();
        if (compoundnbt != null && compoundnbt.m_128425_("ChargedProjectiles", 9)) {
            ListTag listnbt = compoundnbt.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt2 = listnbt.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundnbt2));
            }
        }
        return list;
    }

    public static float[] getRandomSoundPitches(Random rand) {
        boolean flag = rand.nextBoolean();
        return new float[]{1.0f, ECCrossBowItem.getRandomSoundPitch(flag), ECCrossBowItem.getRandomSoundPitch(!flag)};
    }

    private static float getRandomSoundPitch(boolean flagIn) {
        float f = flagIn ? 0.63f : 0.43f;
        return 1.0f / (new Random().nextFloat() * 0.5f + 1.8f) + f;
    }

    public boolean m_40859_(LivingEntity entityIn, ItemStack stack) {
        int multishotLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) + this.multishotLevel;
        int arrowsToFire = multishotLevel == 0 ? 1 : 1 + multishotLevel * 2;
        boolean flag = entityIn instanceof Player && ((Player)entityIn).m_150110_().f_35937_;
        ItemStack itemstack = entityIn.m_6298_(stack);
        ItemStack itemstack2 = itemstack.m_41777_();
        for (int i = 0; i < arrowsToFire; ++i) {
            if (i > 0) {
                itemstack = itemstack2.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack2 = itemstack.m_41777_();
            }
            if (ECCrossBowItem.canAddChargedProjectile(entityIn, stack, itemstack, i > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean canAddChargedProjectile(LivingEntity livingEntity, ItemStack stack, ItemStack stack1, boolean b, boolean b1) {
        ItemStack itemstack;
        boolean flag;
        if (stack1.m_41619_()) {
            return false;
        }
        boolean bl = flag = b1 && stack1.m_41720_() instanceof ArrowItem;
        if (!(flag || b1 || b)) {
            itemstack = stack1.m_41620_(1);
            if (stack1.m_41619_() && livingEntity instanceof Player) {
                ((Player)livingEntity).m_150109_().m_36057_(stack1);
            }
        } else {
            itemstack = stack1.m_41777_();
        }
        ECCrossBowItem.addChargedProjectile(stack, itemstack);
        return true;
    }

    private static void addChargedProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundTag compoundnbt = crossbow.m_41784_();
        ListTag listnbt = compoundnbt.m_128425_("ChargedProjectiles", 9) ? compoundnbt.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundnbt2 = new CompoundTag();
        projectile.m_41739_(compoundnbt2);
        listnbt.add((Object)compoundnbt2);
        compoundnbt.m_128365_("ChargedProjectiles", (Tag)listnbt);
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.mendingBonus;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (this.mendingBonus != 0.0f) {
            if (this.mendingBonus > 0.0f) {
                list.add(0, (Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(this.mendingBonus))));
            } else if (this.mendingBonus < 0.0f) {
                list.add(0, (Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.RED).m_7220_((Component)new TextComponent(ChatFormatting.RED + " +" + ItemStack.f_41584_.format(this.mendingBonus))));
            }
        }
    }
}

