/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.userofbricks.expandedcombat.enchentments.ECEnchantments;
import com.userofbricks.expandedcombat.item.GauntletMaterials;
import com.userofbricks.expandedcombat.item.IGauntletMaterial;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ECGauntletItem
extends Item
implements ICurioItem {
    private final ResourceLocation GAUNTLET_TEXTURE;
    private final IGauntletMaterial material;
    private final double attackDamage;
    protected final int armorAmount;
    private static final UUID ATTACK_UUID = UUID.fromString("7ce10414-adcc-4bf2-8804-f5dbd39fadaf");
    private static final UUID ARMOR_UUID = UUID.fromString("38faf191-bf78-4654-b349-cc1f4f1143bf");
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("b64fd3d6-a9fe-46a1-a972-90e4b0849678");
    private static final UUID KNOCKBACK_UUID = UUID.fromString("a3617883-03fa-4538-a821-7c0a506e8c56");
    public Boolean hasWeaponInHand = false;

    @ParametersAreNonnullByDefault
    public ECGauntletItem(IGauntletMaterial materialIn, Item.Properties properties) {
        super(properties.m_41499_(materialIn.getDurability()));
        this.material = materialIn;
        this.GAUNTLET_TEXTURE = new ResourceLocation("expanded_combat", "textures/entity/gauntlet/" + materialIn.getName() + ".png");
        this.attackDamage = materialIn.getAttackDamage();
        this.armorAmount = materialIn.getArmorAmount();
    }

    public IGauntletMaterial getMaterial() {
        return this.material;
    }

    public int m_6473_() {
        return this.material.getEnchantability();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.material.getRepairMaterial().test(repair) || super.m_6832_(toRepair, repair);
    }

    public float getXpRepairRatio(ItemStack stack) {
        return this.material == GauntletMaterials.gold ? 4.0f : 2.0f;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        if (this.material == GauntletMaterials.gold) {
            list.add((Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(2L))));
        }
    }

    public int getArmorAmount() {
        return this.armorAmount;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public ResourceLocation getGAUNTLET_TEXTURE() {
        return this.GAUNTLET_TEXTURE;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.m_41720_() instanceof ECGauntletItem && ((ECGauntletItem)stack.m_41720_()).getMaterial() == GauntletMaterials.gold;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_41389_(tab)) {
            ItemStack istack = new ItemStack((ItemLike)this);
            if (this.getMaterial() == GauntletMaterials.steeleaf) {
                istack.m_41663_(Enchantments.f_44965_, 2);
            }
            list.add((Object)istack);
        }
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.getWearer();
        livingEntity.f_19853_.m_5594_(null, new BlockPos(livingEntity.m_20182_()), this.material.getSoundEvent(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        String identifier = slotContext.getIdentifier();
        HashMultimap atts = HashMultimap.create();
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).contains(identifier) && stack.m_41720_() instanceof ECGauntletItem) {
            double attackDamage = ((ECGauntletItem)stack.m_41720_()).getAttackDamage();
            double nagaDamage = ((ECGauntletItem)stack.m_41720_()).getMaterial() == GauntletMaterials.naga ? attackDamage / 2.0 * 3.0 : 0.0;
            double yetiDamage = ((ECGauntletItem)stack.m_41720_()).getMaterial() == GauntletMaterials.yeti ? attackDamage / 2.0 : 0.0;
            int armorAmount = ((ECGauntletItem)stack.m_41720_()).getArmorAmount();
            double knockbackResistance = ((ECGauntletItem)stack.m_41720_()).getMaterial().getKnockbackResistance();
            double toughness = ((ECGauntletItem)stack.m_41720_()).getMaterial().getToughness();
            if (((ECGauntletItem)stack.m_41720_()).hasWeaponInHand.booleanValue()) {
                atts.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ATTACK_UUID, "Attack damage bonus", (attackDamage + (double)Math.round(attackDamage / 2.0 * (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) + nagaDamage + yetiDamage) / 2.0, AttributeModifier.Operation.ADDITION));
            } else {
                atts.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ATTACK_UUID, "Attack damage bonus", attackDamage + (double)Math.round(attackDamage / 2.0 * (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) + nagaDamage + yetiDamage, AttributeModifier.Operation.ADDITION));
            }
            atts.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "Armor bonus", (double)armorAmount, AttributeModifier.Operation.ADDITION));
            atts.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_UUID, "Armor Toughness bonus", toughness, AttributeModifier.Operation.ADDITION));
            atts.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback resistance bonus", knockbackResistance + (double)((float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ECEnchantments.KNOCKBACK_RESISTANCE.get()), (ItemStack)stack) / 5.0f), AttributeModifier.Operation.ADDITION));
            atts.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(KNOCKBACK_UUID, "Knockback bonus", (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)stack), AttributeModifier.Operation.ADDITION));
        }
        return atts;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44980_ || enchantment == Enchantments.f_44989_) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }
}

