/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import com.userofbricks.expandedcombat.client.KeyRegistry;
import java.util.LinkedHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class ECQuiverItem
extends Item
implements ICurioItem {
    private Object model;
    private final ResourceLocation QUIVER_TEXTURE;
    public final int providedSlots;
    private int slotsChecked = 0;

    public ECQuiverItem(String textureName, int providedSlots, Item.Properties properties) {
        super(properties);
        this.QUIVER_TEXTURE = new ResourceLocation("expanded_combat", "textures/entity/" + textureName + ".png");
        this.providedSlots = providedSlots;
    }

    public ResourceLocation getQUIVER_TEXTURE() {
        return this.QUIVER_TEXTURE;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        stack.m_41784_().m_128405_("expanded_combat:slotIndex", 0);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        stack.m_41784_().m_128405_("expanded_combat:slotIndex", 0);
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        super.curioTick(identifier, index, livingEntity, stack);
        CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(ICuriosItemHandler::getCurios).map(stringICurioStacksHandlerMap -> (ICurioStacksHandler)stringICurioStacksHandlerMap.get("arrows")).map(ICurioStacksHandler::getStacks).ifPresent(curioStackHandler -> {
            int countdownTicks = stack.m_41784_().m_128451_("countdown_ticks");
            if (countdownTicks > 0) {
                stack.m_41784_().m_128405_("countdown_ticks", countdownTicks - 1);
            }
            if (KeyRegistry.cycleQuiverLeft.m_90857_() && countdownTicks == 0) {
                this.sycleArrows((IDynamicStackHandler)curioStackHandler, false);
                stack.m_41784_().m_128405_("countdown_ticks", 5);
            }
            if (KeyRegistry.cycleQuiverRight.m_90857_() && countdownTicks == 0) {
                this.sycleArrows((IDynamicStackHandler)curioStackHandler, true);
                stack.m_41784_().m_128405_("countdown_ticks", 5);
            }
        });
    }

    public void sycleArrows(IDynamicStackHandler curioStackHandler, boolean forward) {
        int i;
        LinkedHashMap<Integer, ItemStack> stacks = new LinkedHashMap<Integer, ItemStack>();
        for (i = 0; i < curioStackHandler.getSlots(); ++i) {
            ItemStack arrowstack = curioStackHandler.getStackInSlot(i).m_41777_();
            stacks.put(i, arrowstack);
        }
        for (i = 0; i < curioStackHandler.getSlots(); ++i) {
            int stackIndex = i + (forward ? 1 : -1);
            if (stackIndex < 0) {
                stackIndex = curioStackHandler.getSlots() - 1;
            }
            if (stackIndex >= curioStackHandler.getSlots()) {
                stackIndex = 0;
            }
            curioStackHandler.setStackInSlot(i, stacks.getOrDefault(stackIndex, ItemStack.f_41583_));
        }
        if (curioStackHandler.getStackInSlot(0).m_41619_() && this.slotsChecked <= this.providedSlots) {
            ++this.slotsChecked;
            this.sycleArrows(curioStackHandler, forward);
        } else {
            this.slotsChecked = 0;
        }
    }
}

