/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import com.userofbricks.expandedcombat.client.renderer.model.ECShieldBlockEntityWithoutLevelRenderer;
import com.userofbricks.expandedcombat.item.ShieldMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;

public class ECShieldItem
extends ShieldItem {
    private final int tier;

    public ECShieldItem(int tier, Item.Properties properties) {
        super(properties.m_41487_(1));
        this.tier = tier;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        stack.m_41784_().m_128359_("UL_Material", "empty");
        stack.m_41784_().m_128359_("UR_Material", "empty");
        stack.m_41784_().m_128359_("DL_Material", "empty");
        stack.m_41784_().m_128359_("DR_Material", "empty");
        stack.m_41784_().m_128359_("M_Material", "empty");
        return stack;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            for (ShieldMaterial material : ShieldMaterial.values()) {
                if (material.getTier() != this.tier || material == ShieldMaterial.empty) continue;
                ItemStack stack = this.m_7968_();
                stack.m_41784_().m_128359_("UL_Material", material.getName());
                stack.m_41784_().m_128359_("UR_Material", material.getName());
                stack.m_41784_().m_128359_("DL_Material", material.getName());
                stack.m_41784_().m_128359_("DR_Material", material.getName());
                stack.m_41784_().m_128359_("M_Material", material.getName());
                items.add((Object)stack);
            }
        }
    }

    public int getMaxDamage(ItemStack stack) {
        int durability = 336;
        int ul = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("UL_Material")).getAddedDurability();
        int ur = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("UR_Material")).getAddedDurability();
        int dl = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("DL_Material")).getAddedDurability();
        int dr = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("DR_Material")).getAddedDurability();
        int m = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("M_Material")).getAddedDurability();
        return durability + ul + ur + dl + dr + m;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        Ingredient ul = ShieldMaterial.getFromName(toRepair.m_41784_().m_128461_("UL_Material")).getIngotOrMaterial();
        Ingredient ur = ShieldMaterial.getFromName(toRepair.m_41784_().m_128461_("UR_Material")).getIngotOrMaterial();
        Ingredient dl = ShieldMaterial.getFromName(toRepair.m_41784_().m_128461_("DL_Material")).getIngotOrMaterial();
        Ingredient dr = ShieldMaterial.getFromName(toRepair.m_41784_().m_128461_("DR_Material")).getIngotOrMaterial();
        Ingredient m = ShieldMaterial.getFromName(toRepair.m_41784_().m_128461_("M_Material")).getIngotOrMaterial();
        List<Ingredient> h = this.getNumberOfSame(ul, ur, dl, dr, m);
        List<Ingredient> i = this.getNumberOfSame(ur, ul, dl, dr, m);
        List<Ingredient> j = this.getNumberOfSame(dl, ur, ul, dr, m);
        List<Ingredient> k = this.getNumberOfSame(dr, ur, dl, ul, m);
        List<Ingredient> l = this.getNumberOfSame(m, ur, dl, dr, ul);
        List<Ingredient> first = h.size() > i.size() ? h : i;
        List<Ingredient> second = k.size() > j.size() ? k : j;
        List<Ingredient> third = second.size() > first.size() ? second : first;
        List<Ingredient> result = third.size() > l.size() ? third : l;
        return result.get(0).test(repair);
    }

    private List<Ingredient> getNumberOfSame(Ingredient reference, Ingredient canadate1, Ingredient canadate2, Ingredient canadate3, Ingredient canadate4) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        list.add(reference);
        if (reference == canadate1) {
            list.add(canadate1);
        }
        if (reference == canadate2) {
            list.add(canadate2);
        }
        if (reference == canadate3) {
            list.add(canadate3);
        }
        if (reference == canadate4) {
            list.add(canadate4);
        }
        return list;
    }

    public boolean isShield(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.getMendingBonus(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        String ul = stack.m_41784_().m_128461_("UL_Material");
        String ur = stack.m_41784_().m_128461_("UR_Material");
        String dl = stack.m_41784_().m_128461_("DL_Material");
        String dr = stack.m_41784_().m_128461_("DR_Material");
        String m = stack.m_41784_().m_128461_("M_Material");
        list.add((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material.upper_left").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material." + ul).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        list.add((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material.upper_right").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material." + ur).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        list.add((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material.pegs_trim").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material." + m).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        list.add((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material.lower_left").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material." + dl).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        list.add((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material.lower_right").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)new TranslatableComponent("tooltip.expanded_combat.shield_material." + dr).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        if (this.getMendingBonus(stack) != 0.0f) {
            if (this.getMendingBonus(stack) > 0.0f) {
                list.add((Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(ChatFormatting.GREEN + " " + ItemStack.f_41584_.format(this.getMendingBonus(stack)))));
            } else if (this.getMendingBonus(stack) < 0.0f) {
                list.add((Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.RED).m_7220_((Component)new TextComponent(ChatFormatting.RED + " " + ItemStack.f_41584_.format(this.getMendingBonus(stack)))));
            }
        }
        super.m_7373_(stack, world, list, flag);
    }

    public float getMendingBonus(ItemStack stack) {
        float ul = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("UL_Material")).getMedingBonus() / 5.0f;
        float ur = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("UR_Material")).getMedingBonus() / 5.0f;
        float dl = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("DL_Material")).getMedingBonus() / 5.0f;
        float dr = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("DR_Material")).getMedingBonus() / 5.0f;
        float m = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("M_Material")).getMedingBonus() / 5.0f;
        return ul + ur + dl + dr + m;
    }

    public float getBaseProtection(ItemStack stack) {
        float ul = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("UL_Material")).getBaseProtectionAmmount() / 5.0f;
        float ur = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("UR_Material")).getBaseProtectionAmmount() / 5.0f;
        float dl = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("DL_Material")).getBaseProtectionAmmount() / 5.0f;
        float dr = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("DR_Material")).getBaseProtectionAmmount() / 5.0f;
        float m = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("M_Material")).getBaseProtectionAmmount() / 5.0f;
        return ul + ur + dl + dr + m;
    }

    public float getPercentageProtection(ItemStack stack) {
        float ul = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("UL_Material")).getAfterBasePercentReduction() / 5.0f;
        float ur = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("UR_Material")).getAfterBasePercentReduction() / 5.0f;
        float dl = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("DL_Material")).getAfterBasePercentReduction() / 5.0f;
        float dr = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("DR_Material")).getAfterBasePercentReduction() / 5.0f;
        float m = ShieldMaterial.getFromName(stack.m_41784_().m_128461_("M_Material")).getAfterBasePercentReduction() / 5.0f;
        return ul + ur + dl + dr + m;
    }

    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new ECShieldBlockEntityWithoutLevelRenderer();
            }
        });
    }

    public int getTier() {
        return this.tier;
    }
}

