/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.userofbricks.expandedcombat.entity.AttributeRegistry;
import com.userofbricks.expandedcombat.item.IWeaponTier;
import com.userofbricks.expandedcombat.item.IWeaponType;
import com.userofbricks.expandedcombat.item.WeaponTier;
import com.userofbricks.expandedcombat.item.WeaponTypes;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ECWeaponItem
extends SwordItem {
    private final IWeaponTier weaponTier;
    private final IWeaponType type;
    private final float AttackDamage;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    protected static final UUID ATTACK_KNOCKBACK_MODIFIER = UUID.fromString("a3617883-03fa-4538-a821-7c0a506e8c56");
    protected static final UUID ATTACK_REACH_MODIFIER = UUID.fromString("bc644060-615a-4259-a648-5367cd0d45fa");

    public ECWeaponItem(IWeaponTier tierIn, IWeaponType typeIn, Item.Properties builderIn) {
        super(new Tier(){

            public int m_6609_() {
                return 0;
            }

            public float m_6624_() {
                return 0.0f;
            }

            public float m_6631_() {
                return 0.0f;
            }

            public int m_6604_() {
                return 0;
            }

            public int m_6601_() {
                return 0;
            }

            public Ingredient m_6282_() {
                return null;
            }
        }, 0, 0.0f, builderIn.m_41499_(tierIn.getMaxUses()));
        this.weaponTier = tierIn;
        this.type = typeIn;
        this.AttackDamage = (float)this.type.getBaseAttackDamage() + this.weaponTier.getAttackDamage();
        float steeleafKnockback = this.weaponTier == WeaponTier.IRONWOOD ? 0.2f : 0.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.AttackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.type.getBaseAttackSpead(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER, "Weapon modifier", (double)(this.type.getKnockback() + steeleafKnockback), AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public static void setAtributeModifierMultimap(ECWeaponItem weaponItem) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)weaponItem.m_43299_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)weaponItem.getWeaponType().getBaseAttackSpead(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER, "Weapon modifier", (double)weaponItem.getWeaponType().getKnockback(), AttributeModifier.Operation.ADDITION));
        if (ForgeRegistries.ATTRIBUTES.containsKey(new ResourceLocation("dungeons_gear:attack_reach"))) {
            builder.put((Object)Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("dungeons_gear:attack_reach"))), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", weaponItem.getAttackRange(), AttributeModifier.Operation.ADDITION));
        } else {
            builder.put((Object)((Attribute)AttributeRegistry.ATTACK_REACH.get()), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", weaponItem.getAttackRange(), AttributeModifier.Operation.ADDITION));
        }
        weaponItem.attributeModifiers = builder.build();
    }

    public IWeaponTier getWeaponTier() {
        return this.weaponTier;
    }

    public IWeaponType getWeaponType() {
        return this.type;
    }

    public float m_43299_() {
        return this.AttackDamage;
    }

    public double getAttackRange() {
        return this.getWeaponType().getBaseAttackRange();
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        Material material = state.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && material != Material.f_76301_ && !state.m_60620_((Tag)BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean m_7579_(ItemStack weapon, LivingEntity target, LivingEntity attacker) {
        boolean result = super.m_7579_(weapon, target, attacker);
        if (this.getWeaponTier() == WeaponTier.FIERY) {
            if (result && !target.f_19853_.f_46443_ && !target.m_5825_()) {
                target.m_7311_(15);
            } else {
                Random random = new Random();
                for (int var1 = 0; var1 < 20; ++var1) {
                    double px = target.m_20185_() + (double)(random.nextFloat() * target.m_20205_() * 2.0f) - (double)target.m_20205_();
                    double py = target.m_20186_() + (double)(random.nextFloat() * target.m_20206_());
                    double pz = target.m_20189_() + (double)(random.nextFloat() * target.m_20205_() * 2.0f) - (double)target.m_20205_();
                    target.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, px, py, pz, 0.02, 0.02, 0.02);
                }
            }
        } else if (this.getWeaponTier() == WeaponTier.KNIGHTLY && target.m_21230_() > 0) {
            target.m_6469_(DamageSource.f_19319_, 2.0f);
            target.f_20916_ = 0;
        }
        return result;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState blockIn) {
        return blockIn.m_60713_(Blocks.f_50033_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        return equipmentSlot == EquipmentSlot.MAINHAND || this.getWeaponType().getWieldingType() == WeaponTypes.WieldingType.DUALWIELD && equipmentSlot == EquipmentSlot.OFFHAND ? this.attributeModifiers : super.getAttributeModifiers(equipmentSlot, stack);
    }

    public int m_6473_() {
        return this.weaponTier.getEnchantability();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.weaponTier.getRepairMaterial().get().test(repair);
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.type.getTypeMendingBonus() + this.weaponTier.getMendingBonus();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        if (this.getWeaponTier() == WeaponTier.FIERY) {
            list.add((Component)new TranslatableComponent("tooltip.expanded_combat.fiery.weapon"));
        } else if (this.getWeaponTier() == WeaponTier.KNIGHTLY) {
            list.add((Component)new TranslatableComponent("tooltip.expanded_combat.knightly.weapon"));
        }
        float mendingBonus = this.type.getTypeMendingBonus() + this.weaponTier.getMendingBonus();
        if (mendingBonus != 0.0f) {
            if (mendingBonus > 0.0f) {
                list.add((Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(mendingBonus))));
            } else if (mendingBonus < 0.0f) {
                list.add((Component)new TranslatableComponent("tooltip.expanded_combat.mending_bonus").m_130940_(ChatFormatting.RED).m_7220_((Component)new TextComponent(ChatFormatting.RED + " " + ItemStack.f_41584_.format(mendingBonus))));
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        return new TranslatableComponent(this.getWeaponTier().getTierName()).m_130946_(" ").m_7220_((Component)this.getWeaponType().getTypeName());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.OFF_HAND && worldIn.f_46443_) {
            ItemStack offhand = playerIn.m_21120_(handIn);
            return InteractionResultHolder.m_19096_((Object)offhand);
        }
        return InteractionResultHolder.m_19098_((Object)playerIn.m_21120_(handIn));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_41389_(tab)) {
            ItemStack istack = new ItemStack((ItemLike)this);
            if (this.getWeaponTier() == WeaponTier.STEELEAF) {
                istack.m_41663_(Enchantments.f_44982_, 2);
            }
            list.add((Object)istack);
        }
    }

    public static class HasPotionAndIsDyeable
    extends HasPotion
    implements DyeableLeatherItem {
        public HasPotionAndIsDyeable(IWeaponTier tierIn, IWeaponType typeIn, Item.Properties builderIn) {
            super(tierIn, typeIn, builderIn);
        }
    }

    public static class HasPotion
    extends ECWeaponItem {
        public HasPotion(IWeaponTier tierIn, IWeaponType typeIn, Item.Properties builderIn) {
            super(tierIn, typeIn, builderIn);
        }

        @Override
        public boolean m_7579_(ItemStack weapon, LivingEntity target, LivingEntity attacker) {
            if (PotionUtils.m_43579_((ItemStack)weapon) != Potions.f_43598_) {
                for (MobEffectInstance effectInstance : PotionUtils.m_43579_((ItemStack)weapon).m_43488_()) {
                    MobEffectInstance potionEffect = new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_() / 2);
                    target.m_7292_(potionEffect);
                }
            }
            return super.m_7579_(weapon, target, attacker);
        }
    }

    public static class Dyeable
    extends ECWeaponItem
    implements DyeableLeatherItem {
        public Dyeable(IWeaponTier tierIn, IWeaponType typeIn, Item.Properties builderIn) {
            super(tierIn, typeIn, builderIn);
        }
    }
}

