/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item.recipes;

import com.userofbricks.expandedcombat.item.ECWeaponItem;
import com.userofbricks.expandedcombat.item.recipes.RecipeSerializerInit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ECScytheRecipe
extends CustomRecipe {
    public ECScytheRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        int numPotionWeapons = 0;
        int numPotions = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (itemStack.m_41720_() instanceof ECWeaponItem.HasPotion) {
                if (PotionUtils.m_43579_((ItemStack)itemStack).m_43488_().size() != 0) {
                    return false;
                }
                if (numPotionWeapons > 0) {
                    return false;
                }
                ++numPotionWeapons;
                continue;
            }
            if (!(itemStack.m_41720_() instanceof PotionItem)) continue;
            if (numPotions > 0) {
                return false;
            }
            Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
            for (MobEffectInstance e : potion.m_43488_()) {
                if (!e.m_19544_().equals(MobEffects.f_19602_)) continue;
                return false;
            }
            ++numPotions;
        }
        return numPotionWeapons == 1 && numPotions == 1;
    }

    public ItemStack assemble(CraftingContainer inv) {
        Potion potionEffect = null;
        ItemStack potionWeaponItem = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (item instanceof ECWeaponItem.HasPotion) {
                potionWeaponItem = stack;
                continue;
            }
            if (!(inv.m_8020_(i).m_41720_() instanceof PotionItem)) continue;
            potionEffect = PotionUtils.m_43579_((ItemStack)inv.m_8020_(i));
        }
        if (potionEffect == null || potionWeaponItem == null) {
            return ItemStack.f_41583_;
        }
        PotionUtils.m_43549_(potionWeaponItem, potionEffect);
        return potionWeaponItem;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerInit.EC_POTION_WEAPON_SERIALIZER.get();
    }
}

