/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item.recipes;

import com.google.gson.JsonObject;
import com.userofbricks.expandedcombat.item.ECItems;
import com.userofbricks.expandedcombat.item.ECShieldItem;
import com.userofbricks.expandedcombat.item.ShieldMaterial;
import com.userofbricks.expandedcombat.item.recipes.RecipeSerializerInit;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

@MethodsReturnNonnullByDefault
public class ShieldSmithingRecipie
implements Recipe<Container> {
    public static final ResourceLocation SHIELD_RECIPE_ID = new ResourceLocation("expanded_combat", "ec_shields");
    private final ResourceLocation id;

    public ShieldSmithingRecipie(ResourceLocation id) {
        this.id = id;
    }

    public boolean m_5818_(Container inventory, @Nonnull Level world) {
        int shieldTier;
        ItemStack base = inventory.m_8020_(0);
        if (!(base.m_41720_() instanceof ECShieldItem) && base.m_41720_() != Items.f_42740_) {
            return false;
        }
        ShieldMaterial ul_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("UL_Material"));
        ShieldMaterial ur_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("UR_Material"));
        ShieldMaterial dl_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("DL_Material"));
        ShieldMaterial dr_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("DR_Material"));
        ShieldMaterial m_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("M_Material"));
        ShieldMaterial addition_ul_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(1));
        ShieldMaterial addition_ur_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(2));
        ShieldMaterial addition_dl_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(4));
        ShieldMaterial addition_dr_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(5));
        ShieldMaterial addition_m_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(3));
        if (addition_ul_material.isSingleAddition() || addition_ur_material.isSingleAddition() || addition_dl_material.isSingleAddition() || addition_dr_material.isSingleAddition() || addition_m_material.isSingleAddition()) {
            return false;
        }
        int highestTier = Math.max(Math.max(Math.max(addition_dr_material.getTier(), addition_dl_material.getTier()), Math.max(addition_ul_material.getTier(), addition_ur_material.getTier())), addition_m_material.getTier());
        int n = shieldTier = base.m_41720_() instanceof ECShieldItem ? ((ECShieldItem)base.m_41720_()).getTier() : 0;
        if (highestTier > shieldTier + 1 || highestTier == 0) {
            return false;
        }
        Ingredient ul = addition_ul_material.getIngotOrMaterial();
        Ingredient ur = addition_ur_material.getIngotOrMaterial();
        Ingredient dl = addition_dl_material.getIngotOrMaterial();
        Ingredient dr = addition_dr_material.getIngotOrMaterial();
        Ingredient m = addition_m_material.getIngotOrMaterial();
        boolean is_ul = ul.test(inventory.m_8020_(1)) && ul_material != addition_ul_material && ul_material.getTier() <= addition_ul_material.getTier() || addition_ul_material.isEmpty();
        boolean is_ur = ur.test(inventory.m_8020_(2)) && ur_material != addition_ur_material && ur_material.getTier() <= addition_ur_material.getTier() || addition_ur_material.isEmpty();
        boolean is_dl = dl.test(inventory.m_8020_(4)) && dl_material != addition_dl_material && dl_material.getTier() <= addition_dl_material.getTier() || addition_dl_material.isEmpty();
        boolean is_dr = dr.test(inventory.m_8020_(5)) && dr_material != addition_dr_material && dr_material.getTier() <= addition_dr_material.getTier() || addition_dr_material.isEmpty();
        boolean is_m = m.test(inventory.m_8020_(3)) && m_material != addition_m_material && m_material.getTier() <= addition_m_material.getTier() || addition_m_material.isEmpty();
        return is_ul && is_ur && is_dl && is_dr && is_m;
    }

    public ItemStack m_5874_(Container inventory) {
        ItemStack base = inventory.m_8020_(0);
        ShieldMaterial ul_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("UL_Material"));
        ShieldMaterial ur_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("UR_Material"));
        ShieldMaterial dl_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("DL_Material"));
        ShieldMaterial dr_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("DR_Material"));
        ShieldMaterial m_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("M_Material"));
        ShieldMaterial addition_ul_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(1));
        ShieldMaterial addition_ur_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(2));
        ShieldMaterial addition_dl_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(4));
        ShieldMaterial addition_dr_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(5));
        ShieldMaterial addition_m_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(3));
        int highestTier = Math.max(Math.max(Math.max(addition_dr_material.getTier(), addition_dl_material.getTier()), Math.max(addition_ul_material.getTier(), addition_ur_material.getTier())), Math.max(addition_m_material.getTier(), base.m_41720_() instanceof ECShieldItem ? ((ECShieldItem)base.m_41720_()).getTier() : 0));
        ShieldMaterial result_ul_material = addition_ul_material.isEmpty() ? ul_material : addition_ul_material;
        ShieldMaterial result_ur_material = addition_ur_material.isEmpty() ? ur_material : addition_ur_material;
        ShieldMaterial result_dl_material = addition_dl_material.isEmpty() ? dl_material : addition_dl_material;
        ShieldMaterial result_dr_material = addition_dr_material.isEmpty() ? dr_material : addition_dr_material;
        ShieldMaterial result_m_material = addition_m_material.isEmpty() ? m_material : addition_m_material;
        ItemStack result = new ItemStack((ItemLike)Items.f_42740_);
        if (highestTier == 1) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_1.get());
        } else if (highestTier == 2) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_2.get());
        } else if (highestTier == 3) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_3.get());
        } else if (highestTier == 4) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_4.get());
        }
        result.m_41784_().m_128359_("UL_Material", result_ul_material.getName());
        result.m_41784_().m_128359_("UR_Material", result_ur_material.getName());
        result.m_41784_().m_128359_("DL_Material", result_dl_material.getName());
        result.m_41784_().m_128359_("DR_Material", result_dr_material.getName());
        result.m_41784_().m_128359_("M_Material", result_m_material.getName());
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 6;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerInit.EC_SHIELD_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Objects.requireNonNull((RecipeType)Registry.f_122864_.m_7745_(SHIELD_RECIPE_ID));
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean isAdditionIngredient(ItemStack stack) {
        for (ShieldMaterial material : ShieldMaterial.values()) {
            if (!material.getIngotOrMaterial().test(stack) || material.isSingleAddition()) continue;
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShieldSmithingRecipie> {
        public ShieldSmithingRecipie fromJson(ResourceLocation location, JsonObject jsonObject) {
            return new ShieldSmithingRecipie(location);
        }

        public ShieldSmithingRecipie fromNetwork(ResourceLocation location, FriendlyByteBuf packetBuffer) {
            return new ShieldSmithingRecipie(location);
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, ShieldSmithingRecipie shieldSmithingRecipie) {
        }
    }
}

