/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.userofbricks.expandedcombat.item.recipes.IFletchingRecipe;
import com.userofbricks.expandedcombat.item.recipes.RecipeSerializerInit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SingleFletchingRecipe
implements IFletchingRecipe {
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;
    private final ResourceLocation id;

    public SingleFletchingRecipe(ResourceLocation resourceLocation, Ingredient baseIn, Ingredient additionIn, ItemStack resultIn) {
        this.id = resourceLocation;
        this.base = baseIn;
        this.addition = additionIn;
        this.result = resultIn;
    }

    public boolean m_5818_(Container iInventory, Level world) {
        return this.base.test(iInventory.m_8020_(0)) && this.addition.test(iInventory.m_8020_(1));
    }

    public ItemStack m_5874_(Container iInventory) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundnbt = iInventory.m_8020_(0).m_41783_();
        if (compoundnbt != null) {
            itemstack.m_41751_(compoundnbt.m_6426_());
        }
        return itemstack;
    }

    @Override
    public Ingredient getBase() {
        return this.base;
    }

    @Override
    public Ingredient getAddition() {
        return this.addition;
    }

    @Override
    public boolean isAdditionIngredient(ItemStack p_241456_1_) {
        return this.addition.test(p_241456_1_);
    }

    @Override
    public int getMaxCraftingAmount() {
        return 1;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Blocks.f_50622_);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerInit.EC_SINGLE_FLETCHING_SERIALIZER.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.base, this.addition});
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SingleFletchingRecipe> {
        public SingleFletchingRecipe fromJson(ResourceLocation location, JsonObject jsonObject) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"base"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new SingleFletchingRecipe(location, ingredient, ingredient1, itemstack);
        }

        public SingleFletchingRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf packetBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packetBuffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)packetBuffer);
            ItemStack itemstack = packetBuffer.m_130267_();
            return new SingleFletchingRecipe(location, ingredient, ingredient1, itemstack);
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, SingleFletchingRecipe fletchingRecipe) {
            fletchingRecipe.base.m_43923_(packetBuffer);
            fletchingRecipe.addition.m_43923_(packetBuffer);
            packetBuffer.m_130055_(fletchingRecipe.result);
        }
    }
}

