/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item.recipes;

import com.google.gson.JsonObject;
import com.userofbricks.expandedcombat.item.ECItems;
import com.userofbricks.expandedcombat.item.ECShieldItem;
import com.userofbricks.expandedcombat.item.ShieldMaterial;
import com.userofbricks.expandedcombat.item.recipes.RecipeSerializerInit;
import com.userofbricks.expandedcombat.item.recipes.ShieldSmithingRecipie;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

@MethodsReturnNonnullByDefault
public class UpgradingShieldSmithingRecipie
extends ShieldSmithingRecipie {
    public UpgradingShieldSmithingRecipie(ResourceLocation id) {
        super(id);
    }

    @Override
    public boolean m_5818_(Container inventory, @Nonnull Level world) {
        int shieldTier;
        ItemStack base = inventory.m_8020_(0);
        if (!(base.m_41720_() instanceof ECShieldItem)) {
            return false;
        }
        ShieldMaterial addition_m_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(3));
        if (!addition_m_material.isSingleAddition()) {
            return false;
        }
        int n = shieldTier = base.m_41720_() instanceof ECShieldItem ? ((ECShieldItem)base.m_41720_()).getTier() : 0;
        if (addition_m_material.getTier() > shieldTier + 1) {
            return false;
        }
        boolean is_ul = inventory.m_8020_(1).m_41619_();
        boolean is_ur = inventory.m_8020_(2).m_41619_();
        boolean is_dl = inventory.m_8020_(4).m_41619_();
        boolean is_dr = inventory.m_8020_(5).m_41619_();
        boolean is_m = !inventory.m_8020_(3).m_41619_();
        return is_ul && is_ur && is_dl && is_dr && is_m;
    }

    @Override
    public ItemStack m_5874_(Container inventory) {
        ItemStack base = inventory.m_8020_(0);
        ShieldMaterial ul_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("UL_Material"));
        ShieldMaterial ur_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("UR_Material"));
        ShieldMaterial dl_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("DL_Material"));
        ShieldMaterial dr_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("DR_Material"));
        ShieldMaterial m_material = ShieldMaterial.getFromName(base.m_41784_().m_128461_("M_Material"));
        ShieldMaterial addition_material = ShieldMaterial.getFromItemStack(inventory.m_8020_(3));
        ShieldMaterial result_ul_material = ul_material == addition_material.getMaterialToUpgrade() ? addition_material : ul_material;
        ShieldMaterial result_ur_material = ur_material == addition_material.getMaterialToUpgrade() ? addition_material : ur_material;
        ShieldMaterial result_dl_material = dl_material == addition_material.getMaterialToUpgrade() ? addition_material : dl_material;
        ShieldMaterial result_dr_material = dr_material == addition_material.getMaterialToUpgrade() ? addition_material : dr_material;
        ShieldMaterial result_m_material = m_material == addition_material.getMaterialToUpgrade() ? addition_material : m_material;
        int highestTier = Math.max(addition_material.getTier(), base.m_41720_() instanceof ECShieldItem ? ((ECShieldItem)base.m_41720_()).getTier() : 0);
        ItemStack result = new ItemStack((ItemLike)Items.f_42740_);
        if (highestTier == 1) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_1.get());
        } else if (highestTier == 2) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_2.get());
        } else if (highestTier == 3) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_3.get());
        } else if (highestTier == 4) {
            result = new ItemStack((ItemLike)ECItems.SHIELD_TIER_4.get());
        }
        result.m_41784_().m_128359_("UL_Material", result_ul_material.getName());
        result.m_41784_().m_128359_("UR_Material", result_ur_material.getName());
        result.m_41784_().m_128359_("DL_Material", result_dl_material.getName());
        result.m_41784_().m_128359_("DR_Material", result_dr_material.getName());
        result.m_41784_().m_128359_("M_Material", result_m_material.getName());
        return result;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerInit.EC_UPGRADING_SHIELD_SERIALIZER.get();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return Objects.requireNonNull((RecipeType)Registry.f_122864_.m_7745_(ShieldSmithingRecipie.SHIELD_RECIPE_ID));
    }

    @ParametersAreNonnullByDefault
    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<UpgradingShieldSmithingRecipie> {
        public UpgradingShieldSmithingRecipie fromJson(ResourceLocation location, JsonObject jsonObject) {
            return new UpgradingShieldSmithingRecipie(location);
        }

        public UpgradingShieldSmithingRecipie fromNetwork(ResourceLocation location, FriendlyByteBuf packetBuffer) {
            return new UpgradingShieldSmithingRecipie(location);
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, UpgradingShieldSmithingRecipie shieldSmithingRecipie) {
        }
    }
}

