/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.mixin;

import com.userofbricks.expandedcombat.mixin.ContainerAccessor;
import java.util.Map;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

@Mixin(value={CuriosContainer.class})
abstract class CurioContainerMixin
extends InventoryMenu {
    @Shadow
    @Final
    public Player player;
    @Shadow
    @Final
    public LazyOptional<ICuriosItemHandler> curiosHandler;

    public CurioContainerMixin(Inventory p_39706_, boolean p_39707_, Player p_39708_) {
        super(p_39706_, p_39707_, p_39708_);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(ILnet/minecraft/world/entity/player/Inventory;)V"}, remap=false)
    private void init(int windowId, Inventory playerInventory, CallbackInfo ci) {
        this.addECSlots();
    }

    @Inject(at={@At(value="RETURN")}, method={"scrollToIndex"}, remap=false)
    private void scroll(int indexIn, CallbackInfo ci) {
        this.addECSlots();
    }

    private void addECSlots() {
        this.curiosHandler.ifPresent(iCuriosItemHandler -> {
            Map curioMap = iCuriosItemHandler.getCurios();
            for (String identifier : curioMap.keySet()) {
                IDynamicStackHandler iDynamicStackHandler;
                ICurioStacksHandler stackHandler;
                if (identifier.equals("quiver")) {
                    stackHandler = (ICurioStacksHandler)curioMap.get(identifier);
                    iDynamicStackHandler = stackHandler.getStacks();
                    ((ContainerAccessor)((Object)this)).$addSlot((Slot)new CurioSlot(this.player, iDynamicStackHandler, 0, identifier, 77, 18, stackHandler.getRenders()));
                }
                if (!identifier.equals("arrows")) continue;
                stackHandler = (ICurioStacksHandler)curioMap.get(identifier);
                iDynamicStackHandler = stackHandler.getStacks();
                ((ContainerAccessor)((Object)this)).$addSlot((Slot)new CurioSlot(this.player, iDynamicStackHandler, 0, identifier, 77, 36, stackHandler.getRenders()));
            }
        });
    }
}

