/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.mixin;

import com.userofbricks.expandedcombat.ExpandedCombat;
import com.userofbricks.expandedcombat.entity.AttributeRegistry;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={Player.class}, priority=1100)
public abstract class PlayerEntityMixin
extends LivingEntity {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Inject(method={"getProjectile"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkQuiver(ItemStack shootable, CallbackInfoReturnable<ItemStack> cir) {
        if (!(shootable.m_41720_() instanceof ProjectileWeaponItem)) {
            return;
        }
        ItemStack quiverStack = CuriosApi.getCuriosHelper().findEquippedCurio(ExpandedCombat.quiver_predicate, (LivingEntity)this).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.f_41583_);
        if (!quiverStack.m_41619_()) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this).map(ICuriosItemHandler::getCurios).map(stringICurioStacksHandlerMap -> (ICurioStacksHandler)stringICurioStacksHandlerMap.get("arrows")).map(ICurioStacksHandler::getStacks).ifPresent(arrowHandler -> {
                ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio(ExpandedCombat.arrow_predicate, (LivingEntity)this).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.f_41583_);
                if (!stack.m_41619_()) {
                    cir.setReturnValue((Object)stack);
                }
            });
        }
    }

    @ModifyConstant(method={"attack"}, constant={@Constant(doubleValue=9.0)})
    private double getAttackReachSquared(double value) {
        double attackReachValue = 3.0;
        attackReachValue = ForgeRegistries.ATTRIBUTES.containsKey(new ResourceLocation("dungeons_gear:attack_reach")) ? this.m_21133_(Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("dungeons_gear:attack_reach")))) : this.m_21133_((Attribute)AttributeRegistry.ATTACK_REACH.get());
        return attackReachValue * attackReachValue;
    }

    @Inject(method={"createAttributes"}, at={@At(value="RETURN")})
    private static void initAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> ci) {
        if (ForgeRegistries.ATTRIBUTES.containsKey(new ResourceLocation("dungeons_gear:attack_reach"))) {
            ((AttributeSupplier.Builder)ci.getReturnValue()).m_22266_(Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("dungeons_gear:attack_reach"))));
        } else {
            ((AttributeSupplier.Builder)ci.getReturnValue()).m_22266_((Attribute)AttributeRegistry.ATTACK_REACH.get());
        }
    }
}

