/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.network.client;

import com.userofbricks.expandedcombat.entity.AttributeRegistry;
import com.userofbricks.expandedcombat.item.ECWeaponItem;
import com.userofbricks.expandedcombat.item.WeaponTypes;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketOffhandAttack {
    private int entityID;

    public PacketOffhandAttack(int entityID) {
        this.entityID = entityID;
    }

    public static void encode(PacketOffhandAttack packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityID);
    }

    public static PacketOffhandAttack decode(FriendlyByteBuf buf) {
        return new PacketOffhandAttack(buf.readInt());
    }

    public static class OffhandHandler {
        public static void handle(PacketOffhandAttack packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet != null) {
                ctx.get().enqueueWork(() -> {
                    ItemStack offhand;
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    Entity target = null;
                    if (player != null) {
                        target = player.f_19853_.m_6815_(packet.entityID);
                    }
                    if (target != null && !(offhand = player.m_21206_()).m_41619_() && offhand.m_41720_() instanceof ECWeaponItem && ((ECWeaponItem)offhand.m_41720_()).getWeaponType().getWieldingType() == WeaponTypes.WieldingType.DUALWIELD) {
                        double distanceSquared;
                        float renderViewEntityOffsetFromPlayerMitigator;
                        double reachSquared;
                        float reach = ForgeRegistries.ATTRIBUTES.containsKey(new ResourceLocation("dungeons_gear:attack_reach")) ? (float)player.m_21133_(Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("dungeons_gear:attack_reach")))) : (float)player.m_21133_((Attribute)AttributeRegistry.ATTACK_REACH.get());
                        if (player.m_7500_()) {
                            reach = (float)((double)reach * 2.0);
                        }
                        if ((reachSquared = (double)((reach += (renderViewEntityOffsetFromPlayerMitigator = 0.2f)) * reach)) >= (distanceSquared = player.m_20280_(target))) {
                            // empty if block
                        }
                    }
                });
            }
        }
    }
}

