/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.extraplayerrenderer.gui;

import com.github.tartaricacid.extraplayerrenderer.config.ConfigFileManager;
import com.github.tartaricacid.extraplayerrenderer.config.ConfigPOJO;
import com.github.tartaricacid.extraplayerrenderer.event.RenderScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiRenderConfig
extends Screen {
    private static final float SCALE_MAX = 360.0f;
    private static final float SCALE_MIN = 8.0f;

    public GuiRenderConfig(ITextComponent titleIn) {
        super(titleIn);
    }

    public void render(int mouseX, int mouseY, float particleTick) {
        super.render(mouseX, mouseY, particleTick);
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        GuiUtils.drawGradientRect((int)0, (int)(middleX - 60), (int)(middleY - 45), (int)(middleX + 70), (int)(middleY + 45), (int)-871296751, (int)-871296751);
        String text = I18n.func_135052_a((String)"gui.extra_player_renderer.config.text", (Object[])new Object[0]);
        this.font.func_78279_b(text, middleX - 50, middleY - 35, 140, -1);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (scroll != 0.0) {
            this.changeScaleValue((float)scroll * 3.0f);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean result = false;
        if (button == 0) {
            RenderScreen.setYawOffset((float)deltaX + RenderScreen.getYawOffset());
            result = true;
        }
        if (button == 1) {
            RenderScreen.setPosX((float)deltaX + RenderScreen.getPosX());
            RenderScreen.setPosY((float)deltaY + RenderScreen.getPosY());
            result = true;
        }
        return result;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (Character.toLowerCase(typedChar) == 'r' && GuiRenderConfig.hasAltDown()) {
            ConfigPOJO pojo = ConfigPOJO.getInstance();
            RenderScreen.setPosX(pojo.getPosX());
            RenderScreen.setPosY(pojo.getPosY());
            RenderScreen.setScale(pojo.getScale());
            RenderScreen.setYawOffset(pojo.getYawOffset());
        }
        return super.charTyped(typedChar, keyCode);
    }

    private void changeScaleValue(float amount) {
        float tmp = RenderScreen.getScale() + amount * RenderScreen.getScale() / 80.0f;
        RenderScreen.setScale(MathHelper.func_76131_a((float)tmp, (float)8.0f, (float)360.0f));
    }

    public void onClose() {
        ConfigFileManager.writeConfigFile(new ConfigPOJO(RenderScreen.getPosX(), RenderScreen.getPosY(), RenderScreen.getScale(), RenderScreen.getYawOffset()));
        super.onClose();
    }
}

