/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes;

import com.google.common.base.Stopwatch;
import gigaherz.eyes.config.BiomeRules;
import gigaherz.eyes.config.ConfigData;
import gigaherz.eyes.config.DimensionRules;
import gigaherz.eyes.entity.EyesEntity;
import java.lang.reflect.Field;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EyesSpawningManager {
    private static final Logger LOGGER = LogManager.getLogger();
    @CapabilityInject(value=EyesSpawningManager.class)
    public static Capability<EyesSpawningManager> INSTANCE;
    private static final ResourceLocation CAP_KEY;
    private final Stopwatch watch = Stopwatch.createUnstarted();
    private final ServerWorld parent;
    private final ServerChunkProvider chunkSource;
    private int cooldown;
    private int ticks;
    private static final Field f_spawnEnemies;

    public static void init() {
        CapabilityManager.INSTANCE.register(EyesSpawningManager.class, (Capability.IStorage)new Capability.IStorage<EyesSpawningManager>(){

            @Nullable
            public INBT writeNBT(Capability<EyesSpawningManager> capability, EyesSpawningManager instance, Direction side) {
                throw new IllegalStateException("Serialization not supported on this object.");
            }

            public void readNBT(Capability<EyesSpawningManager> capability, EyesSpawningManager instance, Direction side, INBT nbt) {
                throw new IllegalStateException("Serialization not supported on this object.");
            }
        }, () -> {
            throw new IllegalStateException("Default instance factory not supported on this object.");
        });
        MinecraftForge.EVENT_BUS.addGenericListener(World.class, EyesSpawningManager::onCapabilityAttach);
        MinecraftForge.EVENT_BUS.addListener(EyesSpawningManager::onWorldTick);
    }

    private static void onCapabilityAttach(AttachCapabilitiesEvent<World> event) {
        final World eventWorld = (World)event.getObject();
        if (eventWorld instanceof ServerWorld) {
            event.addCapability(CAP_KEY, new ICapabilityProvider(){
                final ServerWorld world;
                final LazyOptional<EyesSpawningManager> supplier;
                {
                    this.world = (ServerWorld)eventWorld;
                    this.supplier = LazyOptional.of(() -> new EyesSpawningManager(this.world));
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == INSTANCE) {
                        return this.supplier.cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }

    private static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        event.world.getCapability(INSTANCE).ifPresent(EyesSpawningManager::tick);
    }

    private EyesSpawningManager(ServerWorld world) {
        this.parent = world;
        this.chunkSource = this.parent.func_72863_F();
        this.cooldown = 0;
    }

    public static int getDaysUntilNextHalloween() {
        Calendar nextHalloween;
        Calendar now = Calendar.getInstance();
        if (now.after(nextHalloween = new Calendar.Builder().setDate(now.get(1), 9, 31).setTimeOfDay(23, 59, 59, 999).build())) {
            nextHalloween.add(1, 1);
        }
        return (int)Math.min(ChronoUnit.DAYS.between(now.toInstant(), nextHalloween.toInstant()), 30L);
    }

    public static int getMinutesToMidnight() {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        if (hour > 12) {
            hour -= 24;
        }
        return Math.abs(hour * 24 + minute);
    }

    private boolean isEnemySpawnEnabled() {
        try {
            return (Boolean)f_spawnEnemies.get(this.chunkSource);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing field", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        if (--this.cooldown > 0) {
            return;
        }
        this.cooldown = 150;
        if (!ConfigData.enableNaturalSpawn || !this.parent.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
            return;
        }
        if (!this.isEnemySpawnEnabled()) {
            return;
        }
        if (!DimensionRules.isDimensionAllowed(this.parent)) {
            return;
        }
        try {
            this.watch.start();
            ++this.ticks;
            int daysUntilNextHalloween = EyesSpawningManager.getDaysUntilNextHalloween();
            int minutesToMidnight = EyesSpawningManager.getMinutesToMidnight();
            this.cooldown = this.calculateSpawnCycleInterval(daysUntilNextHalloween, minutesToMidnight);
            int maxTotalEyesPerDimension = this.calculateMaxTotalEyesPerDimension(daysUntilNextHalloween, minutesToMidnight);
            int maxEyesAroundPlayer = this.calculateMaxEyesAroundPlayer(daysUntilNextHalloween, minutesToMidnight);
            int count = this.parent.func_217482_a(EyesEntity.TYPE, e -> ((EyesEntity)((Object)e)).countsTowardSpawnCap()).size();
            if (count >= maxTotalEyesPerDimension) {
                return;
            }
            float d = ConfigData.maxEyesSpawnDistance;
            AxisAlignedBB size = AxisAlignedBB.func_241550_g_((double)d, (double)d, (double)d);
            List players = this.parent.func_217369_A();
            int wrap = Math.min(players.size(), 20);
            for (ServerPlayerEntity player : players) {
                List entities;
                if ((player.func_145782_y() + this.ticks) % wrap != 0 || player.func_175149_v() || (entities = this.parent.func_217394_a(EyesEntity.TYPE, size.func_191194_a(player.func_213303_ch()), e -> !e.countsTowardSpawnCap() && e.func_70032_d((Entity)player) <= (float)ConfigData.maxEyesSpawnDistance)).size() >= maxEyesAroundPlayer) continue;
                this.spawnOneAround(player.func_213303_ch(), player, d);
            }
        }
        finally {
            this.watch.stop();
            long us = this.watch.elapsed(TimeUnit.MICROSECONDS);
            if (us > 10000L) {
                LOGGER.warn("WARNING: Unexpectedly long spawn cycle. It ran for {}ms!", (Object)((double)us / 1000.0));
            }
            this.watch.reset();
        }
    }

    private int calculateSpawnCycleInterval(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValue(ConfigData.spawnCycleIntervalNormal, ConfigData.spawnCycleIntervalMidnight, ConfigData.spawnCycleIntervalHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateMaxTotalEyesPerDimension(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValue(ConfigData.maxTotalEyesPerDimensionNormal, ConfigData.maxTotalEyesPerDimensionMidnight, ConfigData.maxTotalEyesPerDimensionHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateMaxEyesAroundPlayer(int daysUntilNextHalloween, int minutesToMidnight) {
        return Math.max(1, this.calculateTimeBasedValue(ConfigData.maxEyesAroundPlayerNormal, ConfigData.maxEyesAroundPlayerMidnight, ConfigData.maxEyesAroundPlayerHalloween, daysUntilNextHalloween, minutesToMidnight));
    }

    private int calculateTimeBasedValue(int normal, int midnight, int halloween, int daysUntilNextHalloween, int minutesToMidnight) {
        int valueByDate = (halloween - normal) * Math.max(0, 30 - daysUntilNextHalloween) / 30;
        int valueByTime = (midnight - normal) * Math.max(0, 240 - minutesToMidnight) / 240;
        return normal + valueByDate + valueByTime;
    }

    private void spawnOneAround(Vector3d positionVec, ServerPlayerEntity player, float d) {
        float dSqr = d * d;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int i = 0; i < 100; ++i) {
            EyesEntity entity;
            double sX = (double)(this.parent.field_73012_v.nextFloat() * d) + positionVec.func_82615_a();
            double sZ = (double)(this.parent.field_73012_v.nextFloat() * d) + positionVec.func_82616_c();
            pos.func_189532_c(sX, 0.0, sZ);
            int maxY = this.parent.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos.func_177958_n(), pos.func_177952_p());
            double sY = MathHelper.func_151237_a((double)((double)(this.parent.field_73012_v.nextFloat() * d) + positionVec.func_82617_b()), (double)0.0, (double)maxY);
            pos.func_185336_p((int)sY);
            double pX = (double)pos.func_177958_n() + 0.5;
            double pY = pos.func_177956_o();
            double pZ = (double)pos.func_177952_p() + 0.5;
            double distanceSq = player.func_70092_e(pX, pY, pZ);
            if (!(distanceSq < (double)dSqr) || !EyesSpawningManager.isValidSpawnSpot(this.parent, EyesEntity.TYPE, (BlockPos)pos, distanceSq) || (entity = (EyesEntity)EyesEntity.TYPE.func_220349_b(this.parent, null, null, null, (BlockPos)pos, SpawnReason.NATURAL, false, false)) == null) continue;
            int canSpawn = ForgeHooks.canEntitySpawn((MobEntity)entity, (IWorld)this.parent, (double)pX, (double)pY, (double)pZ, null, (SpawnReason)SpawnReason.NATURAL);
            if (canSpawn != -1 && (canSpawn == 1 || entity.func_213380_a((IWorld)this.parent, SpawnReason.NATURAL) && entity.func_205019_a((IWorldReader)this.parent))) {
                this.parent.func_217376_c((Entity)entity);
                return;
            }
            entity.func_70106_y();
        }
    }

    private static boolean isValidSpawnSpot(ServerWorld serverWorld, EntityType<?> entityType, BlockPos pos, double sqrDistanceToClosestPlayer) {
        int instantDespawnDistance = entityType.func_220339_d().func_233671_f_();
        if (!entityType.func_225437_d() && sqrDistanceToClosestPlayer > (double)(instantDespawnDistance * instantDespawnDistance)) {
            return false;
        }
        if (!BiomeRules.isBiomeAllowed(serverWorld.func_226691_t_(pos))) {
            return false;
        }
        return EntitySpawnPlacementRegistry.func_223515_a(entityType, (IServerWorld)serverWorld, (SpawnReason)SpawnReason.NATURAL, (BlockPos)pos, (Random)serverWorld.field_73012_v) && serverWorld.func_226664_a_(entityType.func_220328_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5));
    }

    static {
        CAP_KEY = new ResourceLocation("eyesinthedarkness:eyes_spawning_manager");
        f_spawnEnemies = ObfuscationReflectionHelper.findField(ServerChunkProvider.class, (String)"field_217246_l");
    }
}

