/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import gigaherz.eyes.EyesInTheDarkness;
import gigaherz.eyes.config.ConfigData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class JumpscareOverlay
extends AbstractGui {
    private static final ResourceLocation TEXTURE_EYES = EyesInTheDarkness.location("textures/entity/eyes2.png");
    private static final ResourceLocation TEXTURE_FLASH = EyesInTheDarkness.location("textures/creepy.png");
    public static JumpscareOverlay INSTANCE = new JumpscareOverlay();
    private boolean visible = false;
    private float progress = 0.0f;
    private Minecraft mc = Minecraft.func_71410_x();
    private static final Rectangle2d[] FRAMES = new Rectangle2d[]{new Rectangle2d(0, 0, 13, 6), new Rectangle2d(0, 7, 13, 6), new Rectangle2d(0, 14, 13, 6), new Rectangle2d(0, 21, 13, 6), new Rectangle2d(15, 1, 15, 8), new Rectangle2d(15, 16, 15, 12)};
    private static final int ANIMATION_APPEAR = 10;
    private static final int ANIMATION_LINGER = 90;
    private static final int ANIMATION_BLINK = 60;
    private static final int ANIMATION_SCARE1 = 20;
    private static final int ANIMATION_FADE = 20;
    private static final int ANIMATION_BLINK_START = 100;
    private static final int ANIMATION_SCARE_START = 160;
    private static final int ANIMATION_FADE_START = 180;
    private static final int ANIMATION_TOTAL = 200;

    private JumpscareOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void show(double ex, double ey, double ez) {
        if (ConfigData.jumpscareClient) {
            this.visible = true;
            this.mc.field_71441_e.func_184134_a(ex, ey, ez, EyesInTheDarkness.eyes_jumpscare, SoundCategory.HOSTILE, this.getJumpscareVolume(), 1.0f, false);
        }
    }

    protected float getJumpscareVolume() {
        return (float)ConfigData.eyeIdleVolume;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (this.visible) {
            this.progress += 1.0f;
            if (this.progress >= 200.0f) {
                this.visible = false;
                this.progress = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (!this.visible || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        event.setCanceled(true);
        int screenWidth = event.getWindow().func_198105_m();
        int screenHeight = event.getWindow().func_198083_n();
        float time = this.progress + event.getPartialTicks();
        if (time >= 200.0f) {
            this.visible = false;
            this.progress = 0.0f;
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.clear((int)256, (boolean)false);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)screenWidth, (double)screenHeight, (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        float darkening = MathHelper.func_76131_a((float)Math.min(time / 10.0f, (200.0f - time) / 20.0f), (float)0.0f, (float)1.0f);
        boolean showCreep = false;
        int blinkstate = 0;
        if (time >= 100.0f) {
            if (time >= 160.0f) {
                blinkstate = 1;
                showCreep = time - 160.0f > 20.0f;
            } else {
                float fade = Math.max(0.0f, (time - 100.0f) / 60.0f);
                float blinkspeed = (float)(1.0 + Math.pow(fade, 3.0));
                blinkstate = MathHelper.func_76141_d((float)(20.0f * blinkspeed)) & 1;
                showCreep = blinkstate == 1;
            }
        }
        int alpha = MathHelper.func_76141_d((float)(darkening * 255.0f));
        if (showCreep) {
            int texW = 2048;
            int texH = 1024;
            float scale1 = (float)screenHeight / (float)texH;
            int drawY = 0;
            int drawH = screenHeight;
            int drawW = MathHelper.func_76141_d((float)((float)texW * scale1));
            int drawX = (screenWidth - drawW) / 2;
            RenderSystem.enableBlend();
            this.drawScaledCustomTexture(TEXTURE_FLASH, texW, texH, 0, 0, texW, texH, drawX, drawY, drawW, drawH, alpha << 24 | 0xFFFFFF);
        } else {
            MatrixStack temp = new MatrixStack();
            JumpscareOverlay.func_238467_a_((MatrixStack)temp, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)(alpha << 24));
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
        }
        if (blinkstate != 1) {
            float scale = Float.MAX_VALUE;
            for (Rectangle2d r : FRAMES) {
                float s = Math.min(MathHelper.func_76128_c((double)((double)screenWidth * 0.8 / (double)r.func_199316_c())), MathHelper.func_76128_c((double)((double)screenHeight * 0.8 / (double)r.func_199317_d())));
                scale = Math.min(scale, s);
            }
            scale = Math.min(1.0f, (1.0f + time) / 11.0f) * scale;
            int currentFrame = Math.min(FRAMES.length - 1, MathHelper.func_76141_d((float)((float)FRAMES.length * time / 10.0f)));
            Rectangle2d rect = FRAMES[currentFrame];
            int tx = rect.func_199318_a();
            int ty = rect.func_199319_b();
            int tw = rect.func_199316_c();
            int th = rect.func_199317_d();
            float drawW = (float)tw * scale;
            float drawH = (float)th * scale;
            float drawX = ((float)screenWidth - drawW) / 2.0f;
            float drawY = ((float)screenHeight - drawH) / 2.0f;
            float texW = 32.0f;
            float texH = 32.0f;
            this.drawScaledCustomTexture(TEXTURE_EYES, texW, texH, tx, ty, tw, th, drawX, drawY, drawW, drawH);
        }
        RenderSystem.popMatrix();
    }

    private void drawScaledCustomTexture(ResourceLocation tex, float texW, float texH, int tx, int ty, int tw, int th, float targetX, float targetY, float targetW, float targetH) {
        this.mc.field_71446_o.func_110577_a(tex);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)targetX, (double)targetY, 0.0).func_225583_a_((float)tx / texW, (float)ty / texH).func_181675_d();
        buffer.func_225582_a_((double)targetX, (double)(targetY + targetH), 0.0).func_225583_a_((float)tx / texW, (float)(ty + th) / texH).func_181675_d();
        buffer.func_225582_a_((double)(targetX + targetW), (double)(targetY + targetH), 0.0).func_225583_a_((float)(tx + tw) / texW, (float)(ty + th) / texH).func_181675_d();
        buffer.func_225582_a_((double)(targetX + targetW), (double)targetY, 0.0).func_225583_a_((float)(tx + tw) / texW, (float)ty / texH).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawScaledCustomTexture(ResourceLocation tex, float texW, float texH, int tx, int ty, int tw, int th, float targetX, float targetY, float targetW, float targetH, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        this.mc.field_71446_o.func_110577_a(tex);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_225582_a_((double)targetX, (double)targetY, 0.0).func_225583_a_((float)tx / texW, (float)ty / texH).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)targetX, (double)(targetY + targetH), 0.0).func_225583_a_((float)tx / texW, (float)(ty + th) / texH).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(targetX + targetW), (double)(targetY + targetH), 0.0).func_225583_a_((float)(tx + tw) / texW, (float)(ty + th) / texH).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(targetX + targetW), (double)targetY, 0.0).func_225583_a_((float)(tx + tw) / texW, (float)ty / texH).func_225586_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }
}

