/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeRules {
    private static final List<Rule> rules = Lists.newArrayList();

    static void parseRules(List<? extends String> biomeRules) {
        rules.clear();
        biomeRules.forEach(r -> rules.add(BiomeRules.parse(r)));
        rules.add(BiomeRules.disallowLabel("void"));
    }

    public static boolean isBiomeAllowed(RegistryKey<Biome> key) {
        for (Rule rule : rules) {
            if (!rule.test(key)) continue;
            return rule.allow;
        }
        return true;
    }

    public static boolean isBiomeAllowed(Biome biome) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(biome.getRegistryName()));
        return BiomeRules.isBiomeAllowed((RegistryKey<Biome>)key);
    }

    private static Rule parse(String rule) {
        boolean allow = true;
        if (rule.startsWith("!")) {
            allow = false;
            rule = rule.substring(1);
        }
        boolean isLabel = false;
        if (rule.startsWith("#")) {
            isLabel = true;
            rule = rule.substring(1);
        } else if (rule.equals("*")) {
            rule = null;
        }
        return new Rule(allow, isLabel, rule);
    }

    private static Rule disallowLabel(String label) {
        return new Rule(false, true, label);
    }

    private static class Rule
    implements Predicate<RegistryKey<Biome>> {
        public final boolean allow;
        public final boolean isLabel;
        public final String labelName;
        public final ResourceLocation registryName;
        public final BiomeDictionary.Type labelType;

        private Rule(boolean allow, boolean isLabel, String labelName) {
            this.allow = allow;
            this.isLabel = isLabel;
            this.labelName = labelName;
            if (labelName == null) {
                this.registryName = null;
                this.labelType = null;
            } else if (isLabel) {
                this.registryName = null;
                this.labelType = BiomeDictionary.Type.getType((String)labelName, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            } else {
                this.registryName = new ResourceLocation(labelName);
                this.labelType = null;
            }
        }

        @Override
        public boolean test(RegistryKey<Biome> biome) {
            if (this.labelName == null) {
                return this.allow;
            }
            if (this.isLabel) {
                return BiomeDictionary.hasType(biome, (BiomeDictionary.Type)this.labelType);
            }
            return this.registryName.equals((Object)biome.func_240901_a_());
        }
    }
}

