/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public class DimensionRules {
    private static final List<Rule> rules = Lists.newArrayList();

    static void parseRules(List<? extends String> dimensionRules) {
        rules.clear();
        dimensionRules.forEach(r -> rules.add(DimensionRules.parse(r)));
        rules.add(DimensionRules.disallowLabel("void"));
    }

    public static boolean isDimensionAllowed(ServerWorld world) {
        for (Rule rule : rules) {
            if (rule == null || !rule.test(world)) continue;
            return rule.allow;
        }
        return true;
    }

    private static Rule parse(String rule) {
        boolean allow = true;
        if (rule.startsWith("!")) {
            allow = false;
            rule = rule.substring(1);
        }
        boolean isLabel = false;
        if (rule.startsWith("#")) {
            isLabel = true;
            rule = rule.substring(1);
        } else if (rule.equals("*")) {
            rule = null;
        }
        return new Rule(allow, isLabel, rule);
    }

    private static Rule disallowLabel(String label) {
        return new Rule(false, true, label);
    }

    private static class Rule
    implements Predicate<ServerWorld> {
        public final boolean allow;
        public final boolean isType;
        public final ResourceLocation name;

        private Rule(boolean allow, boolean isType, String key) {
            this.allow = allow;
            this.isType = isType;
            this.name = key == null ? null : new ResourceLocation(key);
        }

        @Override
        public boolean test(ServerWorld world) {
            if (this.name == null) {
                return this.allow;
            }
            if (this.isType) {
                return this.name.equals((Object)world.func_241828_r().func_230520_a_().func_177774_c((Object)world.func_230315_m_()));
            }
            return this.name.equals((Object)world.func_234923_W_().func_240901_a_());
        }
    }
}

