/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.fabric;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.atesab.customcursormod.common.CursorMod;
import fr.atesab.customcursormod.common.config.CursorConfig;
import fr.atesab.customcursormod.common.cursor.CursorClick;
import fr.atesab.customcursormod.common.cursor.CursorType;
import fr.atesab.customcursormod.common.cursor.SelectZone;
import fr.atesab.customcursormod.common.gui.GuiConfig;
import fr.atesab.customcursormod.common.handler.CommonButton;
import fr.atesab.customcursormod.common.handler.CommonElement;
import fr.atesab.customcursormod.common.handler.CommonScreen;
import fr.atesab.customcursormod.common.handler.CommonShaders;
import fr.atesab.customcursormod.common.handler.CommonTextField;
import fr.atesab.customcursormod.common.handler.GameType;
import fr.atesab.customcursormod.common.handler.GuiUtils;
import fr.atesab.customcursormod.common.handler.ResourceLocationCommon;
import fr.atesab.customcursormod.common.handler.StringCommonText;
import fr.atesab.customcursormod.common.handler.TranslationCommonText;
import fr.atesab.customcursormod.common.utils.I18n;
import fr.atesab.customcursormod.fabric.FabricBasicCommonScreen;
import fr.atesab.customcursormod.fabric.FabricCommonButton;
import fr.atesab.customcursormod.fabric.FabricCommonScreen;
import fr.atesab.customcursormod.fabric.FabricCommonShaders;
import fr.atesab.customcursormod.fabric.FabricCommonTextField;
import fr.atesab.customcursormod.fabric.FabricGuiUtils;
import fr.atesab.customcursormod.fabric.FabricResourceLocationCommon;
import fr.atesab.customcursormod.fabric.FabricStringCommonTextImpl;
import fr.atesab.customcursormod.fabric.FabricTranslationCommonTextImpl;
import fr.atesab.customcursormod.fabric.gui.FabricGuiSelectZone;
import fr.atesab.customcursormod.fabric.mixin.HandledScreenMixin;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1074;
import net.minecraft.class_1735;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_408;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;

public class FabricCursorMod
implements ClientModInitializer,
ClientTickEvents.StartTick,
ScreenEvents.AfterInit,
ScreenEvents.AfterRender,
ScreenEvents.AfterTick,
ScreenMouseEvents.AfterMouseClick,
ClientLifecycleEvents.ClientStarted {
    private final CursorMod mod = new CursorMod(GameType.FABRIC);
    public final class_5250 yes = class_2561.method_43471((String)"cursormod.config.yes");
    public final class_5250 no = class_2561.method_43471((String)"cursormod.config.no");

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cursormod").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dynamicCursor").then(ClientCommandManager.argument((String)"dc_value", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            this.mod.getConfig().dynamicCursor = BoolArgumentType.getBool((CommandContext)c, (String)"dc_value");
            ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cursormod.config.dynCursor").method_27693(": ").method_10852((class_2561)(this.mod.getConfig().dynamicCursor ? this.yes : this.no)));
            return 1;
        }))).executes(c -> {
            ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cursormod.config.dynCursor").method_27693(": ").method_10852((class_2561)(this.mod.getConfig().dynamicCursor ? this.yes : this.no)));
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"clickAnimation").then(ClientCommandManager.argument((String)"ca_value", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            this.mod.getConfig().clickAnimation = BoolArgumentType.getBool((CommandContext)c, (String)"ca_value");
            ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cursormod.config.clickAnim").method_27693(": ").method_10852((class_2561)(this.mod.getConfig().clickAnimation ? this.yes : this.no)));
            return 1;
        }))).executes(c -> {
            ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cursormod.config.clickAnim").method_27693(": ").method_10852((class_2561)(this.mod.getConfig().clickAnimation ? this.yes : this.no)));
            return 1;
        }))).executes(c -> {
            this.mod.waiter.register(GuiConfig.create(CommonScreen.getCurrent()));
            return 0;
        })));
        ScreenEvents.AFTER_INIT.register((Object)this);
        ClientLifecycleEvents.CLIENT_STARTED.register((Object)this);
        ClientTickEvents.START_CLIENT_TICK.register((Object)this);
    }

    private List<Field[]> getDeclaredField(Class<?> cls) {
        ArrayList<Field[]> l = new ArrayList<Field[]>();
        l.add(cls.getDeclaredFields());
        while (!cls.equals(Object.class)) {
            cls = cls.getSuperclass();
            l.add(cls.getDeclaredFields());
        }
        return l;
    }

    private boolean isHover(int mouseX, int mouseY, int x, int y, int width, int height) {
        x = Math.min(x + width, x);
        y = Math.min(y + height, y);
        width = Math.abs(width);
        height = Math.abs(height);
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private boolean isHoverButton(int mouseX, int mouseY, class_4264 button) {
        return button != null && button.field_22764 && button.field_22763 && this.isHover(mouseX, mouseY, button.field_22760, button.field_22761, button.method_25368(), button.method_25364());
    }

    private boolean isHoverTextField(int mouseX, int mouseY, class_342 textField) {
        return textField != null && textField.method_1885() && this.isHover(mouseX, mouseY, textField.field_22760, textField.field_22761, textField.method_25368(), textField.method_25364());
    }

    public void afterInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        this.mod.forceNextCursor();
        ScreenEvents.afterRender((class_437)screen).register((Object)this);
        ScreenEvents.afterTick((class_437)screen).register((Object)this);
        ScreenMouseEvents.afterMouseClick((class_437)screen).register((Object)this);
    }

    public static class_1735 getSlotUnderMouse(class_465<?> screen) {
        return ((HandledScreenMixin)screen).getFocusedSlot();
    }

    public void afterRender(class_437 gui, class_4587 matrices, int mouseX, int mouseY, float tickDelta) {
        if (gui == null) {
            return;
        }
        CursorType newCursorType = CursorType.POINTER;
        if (this.mod.getConfig().dynamicCursor) {
            CommonScreen commonScreen;
            if (gui instanceof FabricCommonScreen.FabricCommonScreenHandler) {
                FabricCommonScreen.FabricCommonScreenHandler handle = (FabricCommonScreen.FabricCommonScreenHandler)gui;
                cs = handle.cs;
                for (CommonElement commonElement : ((CommonScreen)cs).childrens) {
                    if (!commonElement.isEnable() || !commonElement.isHover(mouseX, mouseY)) continue;
                    if (commonElement instanceof CommonTextField) {
                        newCursorType = CursorType.BEAM;
                        continue;
                    }
                    if (commonElement instanceof CommonButton) {
                        newCursorType = CursorType.HAND;
                        continue;
                    }
                    if (!(commonElement instanceof SelectZone)) continue;
                    newCursorType = CursorType.CROSS;
                }
            } else {
                cs = this.getDeclaredField(gui.getClass()).iterator();
                while (cs.hasNext()) {
                    Field[] fa;
                    block4: for (Field f : fa = (Field[])cs.next()) {
                        try {
                            f.setAccessible(true);
                            Object o = f.get(gui);
                            if (o == null) continue;
                            if (o instanceof class_342) {
                                if (!this.isHoverTextField(mouseX, mouseY, (class_342)o)) continue;
                                newCursorType = CursorType.BEAM;
                                continue;
                            }
                            if (o instanceof class_4264) {
                                class_4264 b = (class_4264)o;
                                if (!this.isHoverButton(mouseX, mouseY, b)) continue;
                                newCursorType = CursorType.HAND;
                                continue;
                            }
                            if (o instanceof SelectZone) {
                                SelectZone selectZone = (SelectZone)o;
                                if (!selectZone.isHover(mouseX, mouseY) || !selectZone.isEnable()) continue;
                                newCursorType = CursorType.CROSS;
                                continue;
                            }
                            if (!(o instanceof Iterable)) continue;
                            for (Object e : (Iterable)o) {
                                if (e instanceof class_4264) {
                                    class_4264 b = (class_4264)e;
                                    if (!this.isHoverButton(mouseX, mouseY, b)) continue;
                                    newCursorType = CursorType.HAND;
                                    continue;
                                }
                                if (e instanceof class_342) {
                                    if (!this.isHoverTextField(mouseX, mouseY, (class_342)e)) continue;
                                    newCursorType = CursorType.BEAM;
                                    continue;
                                }
                                if (!(e instanceof SelectZone)) continue block4;
                                SelectZone selectZone = (SelectZone)e;
                                if (!this.isHover(mouseX, mouseY, selectZone.getXPosition(), selectZone.getYPosition(), selectZone.getWidth(), selectZone.getHeight()) || !selectZone.isEnable()) continue;
                                newCursorType = CursorType.CROSS;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            class_310 mc = class_310.method_1551();
            if (gui instanceof class_465) {
                class_465 container = (class_465)gui;
                if (mc.field_1724 != null && mc.field_1724.field_7512.method_34255() != null && !mc.field_1724.field_7512.method_34255().method_7909().equals(class_1802.field_8162)) {
                    newCursorType = CursorType.HAND_GRAB;
                } else {
                    class_1735 slot = FabricCursorMod.getSlotUnderMouse(container);
                    if (slot != null && slot.method_7681()) {
                        newCursorType = CursorType.HAND;
                    }
                }
            } else if (gui instanceof class_408) {
                int mx = (int)(mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480());
                int n = (int)(mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507());
                class_2583 style = mc.field_1705.method_1743().method_1816((double)mx, (double)n);
                if (style != null && style.method_10970() != null) {
                    newCursorType = CursorType.HAND;
                }
            }
            if (gui instanceof FabricCommonScreen.FabricCommonScreenHandler) {
                FabricCommonScreen.FabricCommonScreenHandler handler = (FabricCommonScreen.FabricCommonScreenHandler)gui;
                commonScreen = handler.cs;
            } else {
                commonScreen = new FabricBasicCommonScreen(gui);
            }
            for (CursorType cursorType : this.mod.getCursors().keySet()) {
                if (cursorType.getCursorTester() == null || !cursorType.getCursorTester().testCursor(newCursorType, commonScreen, mouseX, mouseY, tickDelta)) continue;
                newCursorType = cursorType;
                break;
            }
        }
        this.mod.changeCursor(newCursorType);
        if (this.mod.getConfig().clickAnimation) {
            Iterator<CursorClick> iterator = this.mod.getCursorClicks().iterator();
            while (iterator.hasNext()) {
                CursorClick cursorClick = iterator.next();
                int posX = (int)cursorClick.getPosX();
                int n = (int)cursorClick.getPosY();
                FabricGuiUtils.getFabric().setShader(FabricCommonShaders.getFabric().getPositionTexShader());
                RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("textures/gui/click_" + cursorClick.getImage() + ".png"));
                FabricGuiUtils.getFabric().drawScaledCustomSizeModalRect(posX - 8, n - 8, 0.0f, 0.0f, 16, 16, 16, 16, 16.0f, 16.0f, -1, true);
                cursorClick.descreaseTime(tickDelta);
                if (!(cursorClick.getTime() <= 0.0f)) continue;
                iterator.remove();
            }
        }
    }

    public void afterMouseClick(class_437 screen, double mouseX, double mouseY, int button) {
        if (button == 0 && this.mod.getConfig().clickAnimation) {
            this.mod.getCursorClicks().add(new CursorClick(mouseX, mouseY));
        }
    }

    public void afterTick(class_437 screen) {
        if (!this.mod.getCursorClicks().isEmpty() && class_310.method_1551().field_1755 == null) {
            this.mod.getCursorClicks().clear();
        }
    }

    public void onClientStarted(class_310 client) {
        File saveDir = new File(client.field_1697, "config");
        try {
            Files.createDirectories(saveDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("can't create directories: " + saveDir, e);
        }
        File save = new File(saveDir, "customcursormod.json");
        this.mod.getConfig().sync(save);
        this.mod.getCursors().values().forEach(CursorConfig::getCursor);
        this.mod.loadData(client.method_22683().method_4490());
    }

    public void onStartTick(class_310 client) {
        this.mod.waiter.tick();
    }

    static {
        SelectZone.SUPPLIER.forType(GameType.FABRIC, o -> new FabricGuiSelectZone(o.xPosition, o.yPosition, o.width, o.height));
        GuiUtils.SUPPLIER.forType(GameType.FABRIC, FabricGuiUtils::getFabric);
        TranslationCommonText.SUPPLIER.forType(GameType.FABRIC, obj -> new FabricTranslationCommonTextImpl(obj.format, obj.args));
        StringCommonText.SUPPLIER.forType(GameType.FABRIC, FabricStringCommonTextImpl::new);
        ResourceLocationCommon.SUPPLIER.forType(GameType.FABRIC, FabricResourceLocationCommon::new);
        CommonButton.SUPPLIER.forType(GameType.FABRIC, FabricCommonButton::new);
        CommonTextField.SUPPLIER.forType(GameType.FABRIC, FabricCommonTextField::new);
        CommonScreen.SUPPLIER.forType(GameType.FABRIC, FabricCommonScreen::new);
        CommonScreen.SUPPLIER_CURRENT.forType(GameType.FABRIC, v -> new FabricBasicCommonScreen(class_310.method_1551().field_1755));
        I18n.SUPPLIER.forType(GameType.FABRIC, obj -> class_1074.method_4662((String)obj.format, (Object[])obj.args));
        CommonShaders.SUPPLIER.forType(GameType.FABRIC, FabricCommonShaders::getFabric);
    }
}

