/*
 * Decompiled with CFR 0.152.
 */
package filteredchests;

import filteredchests.ChestEntry;
import filteredchests.FilteredChests;
import java.util.stream.IntStream;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;

public enum ChestTypes {
    SMALL(3, 3),
    NORMAL(3, 9),
    MEDIUM(4, 11),
    LARGE(6, 11),
    HUGE(10, 10);

    private final ResourceLocation tileContainer = new ResourceLocation("filteredchests", this.toString());
    private final int rows;
    private final int columns;
    private final ResourceLocation gui;
    private final int[] SLOTS;

    private ChestTypes(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.gui = new ResourceLocation("filteredchests", "textures/gui/container/" + this.toString() + ".png");
        this.SLOTS = IntStream.range(0, this.rows * this.columns).toArray();
    }

    public int getSize() {
        return this.rows * this.columns;
    }

    public int[] getSidedSlots() {
        return this.SLOTS;
    }

    public ResourceLocation getGui() {
        return this.gui;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public ResourceLocation registryName() {
        return this.tileContainer;
    }

    public ContainerType<?> getContainer() {
        return this.getEntry().getContainer();
    }

    public TileEntityType<?> getTile() {
        return this.getEntry().getTile();
    }

    private ChestEntry getEntry() {
        return FilteredChests.RegistryEvents.Chests.get(this.toString());
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

