/*
 * Decompiled with CFR 0.152.
 */
package filteredchests;

import filteredchests.ChestEntry;
import filteredchests.ChestTypes;
import filteredchests.client.gui.FilteredChestGui;
import filteredchests.client.tilerenderer.FilteredChestStackRenderer;
import filteredchests.client.tilerenderer.FilteredChestTileEntityRenderer;
import filteredchests.network.PacketHandler;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="filteredchests")
public class FilteredChests {
    public static final String MODID = "filteredchests";

    public FilteredChests() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
    }

    private void init(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RegistryEvents.Chests.values().forEach(e -> ScreenManager.func_216911_a(e.getContainer(), FilteredChestGui::new));
        RegistryEvents.Chests.values().forEach(e -> ClientRegistry.bindTileEntityRenderer(e.getTile(), FilteredChestTileEntityRenderer::new));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static final HashMap<String, ChestEntry> Chests = new HashMap();
        public static final Block Generic;

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            Chests.values().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e.getBlock()));
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            Chests.values().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e.getItem()));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            Chests.values().forEach(e -> event.getRegistry().register(e.getContainer()));
        }

        @SubscribeEvent
        public static void onTilesRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            Chests.values().forEach(e -> event.getRegistry().register(e.getTile()));
        }

        static {
            for (ChestTypes type : ChestTypes.values()) {
                Chests.put(type.toString(), new ChestEntry(type, ItemGroup.field_78031_c));
            }
            Generic = Chests.get(ChestTypes.SMALL.toString()).getBlock();
            FilteredChestStackRenderer.instance.init();
        }
    }
}

