/*
 * Decompiled with CFR 0.152.
 */
package filteredchests.blocks;

import filteredchests.ChestTypes;
import filteredchests.blocks.tileentities.FilteredChestTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class FilteredChestBase
extends Block
implements IWaterLoggable {
    private final ChestTypes type;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public FilteredChestBase(AbstractBlock.Properties props, ChestTypes type) {
        super(props);
        this.type = type;
        this.setRegistryName(this.type.registryName());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ChestTypes getType() {
        return this.type;
    }

    public FilteredChestBase(ChestTypes type) {
        this(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a), type);
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int type, int value) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(type, value);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FilteredChestTile(this.type.getTile(), this.type);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AABB;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean update) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof FilteredChestTile) {
                InventoryHelper.func_219961_a((World)world, (BlockPos)pos, ((FilteredChestTile)tileentity).getItems());
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, update);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof FilteredChestTile) {
            ((FilteredChestTile)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        INamedContainerProvider inamedcontainerprovider = this.func_220052_b(state, world, pos);
        if (inamedcontainerprovider != null) {
            FilteredChestTile tile = (FilteredChestTile)world.func_175625_s(pos);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)inamedcontainerprovider, buf -> {
                buf.writeBoolean(tile.isBlackListed());
                buf.writeBoolean(tile.isFilterLocked());
                buf.writeByte((int)tile.getFilterType());
            });
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
        }
        return ActionResultType.CONSUME;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        return (INamedContainerProvider)world.func_175625_s(pos);
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.func_185907_a(p_185471_2_.func_185800_a((Direction)p_185471_1_.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        Direction direction = p_196258_1_.func_195992_f().func_176734_d();
        FluidState fluidstate = p_196258_1_.func_195991_k().func_204610_c(p_196258_1_.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }
}

