/*
 * Decompiled with CFR 0.152.
 */
package filteredchests.blocks.containers;

import filteredchests.ChestTypes;
import filteredchests.FilterUtils;
import filteredchests.blocks.tileentities.FilteredChestTile;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FilteredChestContainer
extends Container {
    private final IInventory block_inventory;
    private final int inventory_rows;
    private final int inventory_columns;
    private boolean blacklist;
    private boolean locked;
    private byte filter_type;
    private final ChestTypes type;

    private FilteredChestContainer(int id, PlayerInventory playerInventory, FilteredChestTile inventory, ChestTypes chestType) {
        this(id, playerInventory, (IInventory)inventory, chestType);
        this.blacklist = inventory.isBlackListed();
        this.locked = inventory.isFilterLocked();
        this.filter_type = inventory.getFilterType();
    }

    private FilteredChestContainer(int id, PlayerInventory playerInventory, PacketBuffer buffer, ChestTypes chestType) {
        this(id, playerInventory, (IInventory)new Inventory(chestType.getSize() + 9), chestType);
        this.blacklist = buffer.readBoolean();
        this.locked = buffer.readBoolean();
        this.filter_type = buffer.readByte();
    }

    protected FilteredChestContainer(int id, PlayerInventory playerInventory, IInventory inventory, ChestTypes type) {
        super(type.getContainer(), id);
        int col;
        int col2;
        int row;
        this.inventory_rows = type.getRows();
        this.inventory_columns = type.getColumns();
        FilteredChestContainer.func_216962_a((IInventory)inventory, (int)(this.inventory_rows * this.inventory_columns));
        this.type = type;
        this.block_inventory = inventory;
        inventory.func_174889_b(playerInventory.field_70458_d);
        int i = (this.inventory_rows - 4) * 18 + 32;
        int leftShift1 = this.inventory_columns > 9 ? this.inventory_columns * 9 - 73 : 8;
        int leftShift2 = this.inventory_columns > 9 ? 8 : 89 - this.inventory_columns * 9;
        for (row = 0; row < this.inventory_rows; ++row) {
            for (col2 = 0; col2 < this.inventory_columns; ++col2) {
                this.func_75146_a(new FilteredSlot(inventory, col2 + row * this.inventory_columns, leftShift2 + col2 * 18, 50 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col2 = 0; col2 < 9; ++col2) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col2 + row * 9 + 9, leftShift1 + col2 * 18, 103 + row * 18 + i));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, col, leftShift1 + col * 18, 161 + i));
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new FilterSlot(inventory, this.inventory_rows * this.inventory_columns + col, leftShift1 + col * 18, 18));
        }
    }

    public boolean switchBlackListed() {
        this.blacklist = !this.blacklist;
        ((FilteredChestTile)this.getInventory()).switchBlackListed();
        return this.blacklist;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setBlackListed(boolean mode) {
        this.blacklist = mode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBlackListed() {
        return this.blacklist;
    }

    public boolean switchLocked() {
        this.locked = !this.locked;
        ((FilteredChestTile)this.getInventory()).switchLocked();
        return this.locked;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setLocked(boolean islocked) {
        this.locked = islocked;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isLocked() {
        return this.locked;
    }

    public byte nextFilterType() {
        this.filter_type = (byte)((this.filter_type + 1) % 3);
        ((FilteredChestTile)this.getInventory()).nextFilterType();
        return this.filter_type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setFilterType(byte type) {
        this.filter_type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public byte getFilterType() {
        return this.filter_type;
    }

    public ChestTypes getChestType() {
        return this.type;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.block_inventory || slot.getSlotIndex() < this.inventory_rows * this.inventory_columns;
    }

    public ItemStack func_184996_a(int slot, int p_184996_2_, ClickType click, PlayerEntity player) {
        if (slot >= 0 && this.field_75151_b.get(slot) instanceof FilterSlot) {
            ItemStack hold = player.field_71071_by.func_70445_o();
            if (!this.locked) {
                ((Slot)this.field_75151_b.get(slot)).func_75215_d(hold);
            }
            return hold;
        }
        return super.func_184996_a(slot, p_184996_2_, click, player);
    }

    public static FilteredChestContainer smallChest(int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        return new FilteredChestContainer(id, playerInventory, buffer, ChestTypes.SMALL);
    }

    public static FilteredChestContainer mediumChest(int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        return new FilteredChestContainer(id, playerInventory, buffer, ChestTypes.MEDIUM);
    }

    public static FilteredChestContainer Chest(int id, PlayerInventory playerInventory, PacketBuffer buffer, ChestTypes type) {
        return new FilteredChestContainer(id, playerInventory, buffer, type);
    }

    public static FilteredChestContainer Chest(int id, PlayerInventory playerInventory, FilteredChestTile inventory, ChestTypes type) {
        return new FilteredChestContainer(id, playerInventory, inventory, type);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.inventory_rows * this.inventory_columns ? !this.func_75135_a(itemstack1, this.inventory_rows * this.inventory_columns, this.field_75151_b.size() - 9, true) : !this.mayPlace(itemstack1) || !this.func_75135_a(itemstack1, 0, this.inventory_rows * this.inventory_columns, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.block_inventory.func_70300_a(player);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.block_inventory.func_174886_c(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRowCount() {
        return this.inventory_rows;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColumnCount() {
        return this.inventory_columns;
    }

    public IInventory getInventory() {
        return this.block_inventory;
    }

    public boolean mayPlace(ItemStack stack) {
        int size = this.block_inventory.func_70302_i_();
        for (int index = 9; index > 0; --index) {
            ItemStack filterStack = this.block_inventory.func_70301_a(size - index);
            if (!(this.filter_type == 0 && stack.func_77973_b().equals(filterStack.func_77973_b()) || this.filter_type == 1 && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)filterStack) && stack.func_77973_b().equals(filterStack.func_77973_b())) && (this.filter_type != 2 || !FilterUtils.allowdedIn(stack.func_77973_b(), filterStack.func_77973_b().func_77640_w()))) continue;
            return !this.blacklist;
        }
        return this.blacklist;
    }

    class FilterSlot
    extends Slot {
        public FilterSlot(IInventory inventory, int id, int x, int y) {
            super(inventory, id, x, y);
        }

        public boolean func_82869_a(PlayerEntity player) {
            return false;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public void func_75215_d(ItemStack stack) {
            if (!stack.func_190926_b()) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                this.field_75224_c.func_70299_a(this.getSlotIndex(), copy);
            } else {
                this.field_75224_c.func_70299_a(this.getSlotIndex(), ItemStack.field_190927_a);
            }
            this.func_75218_e();
        }

        @Nonnull
        public ItemStack func_75209_a(int amount) {
            return ItemStack.field_190927_a;
        }
    }

    class FilteredSlot
    extends Slot {
        public FilteredSlot(IInventory inventory, int id, int x, int y) {
            super(inventory, id, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return FilteredChestContainer.this.mayPlace(stack);
        }
    }
}

