/*
 * Decompiled with CFR 0.152.
 */
package filteredchests.blocks.tileentities;

import filteredchests.ChestTypes;
import filteredchests.FilterUtils;
import filteredchests.blocks.FilteredChestBase;
import filteredchests.blocks.containers.FilteredChestContainer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class FilteredChestTile
extends LockableTileEntity
implements IChestLid,
ITickableTileEntity,
ISidedInventory {
    private final int size;
    private NonNullList<ItemStack> items;
    protected float openness;
    protected float previousOpenness;
    protected int openCount;
    private int tickInterval;
    private LazyOptional<IItemHandlerModifiable> handler;
    private NonNullList<ItemStack> filter = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private boolean blacklist = true;
    private boolean locked = false;
    private byte filter_type;
    private final ChestTypes chesttype;

    public FilteredChestTile(TileEntityType<?> tiletype, ChestTypes type) {
        super(tiletype);
        this.size = type.getSize();
        this.items = NonNullList.func_191197_a((int)this.size, (Object)ItemStack.field_190927_a);
        this.chesttype = type;
    }

    public static Supplier<FilteredChestTile> ChestTile(ChestTypes type) {
        return () -> new FilteredChestTile(type.getTile(), type);
    }

    public static FilteredChestTile small() {
        return new FilteredChestTile(ChestTypes.SMALL.getTile(), ChestTypes.SMALL);
    }

    public ChestTypes getChestType() {
        return this.chesttype;
    }

    public int func_70302_i_() {
        return this.size + 9;
    }

    public int getRealSize() {
        return this.size;
    }

    public boolean func_191420_l() {
        return this.items.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.getRealSize()) {
            return (ItemStack)this.filter.get(slot - this.getRealSize());
        }
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.getItems(), (int)slot, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.items, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot >= this.getRealSize()) {
            this.filter.set(slot - this.getRealSize(), (Object)stack);
        } else {
            this.getItems().set(slot, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.chest");
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return FilteredChestContainer.Chest(id, playerInventory, this, this.chesttype);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.items = NonNullList.func_191197_a((int)this.getRealSize(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        this.blacklist = compound.func_74767_n("mode");
        this.locked = compound.func_74767_n("filter_locked");
        this.filter_type = compound.func_74771_c("filter_type");
        this.filter = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        if (compound.func_74764_b("filter")) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("filter"), this.filter);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        CompoundNBT filter = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)filter, this.filter);
        compound.func_218657_a("filter", (INBT)filter);
        compound.func_74757_a("mode", this.blacklist);
        compound.func_74757_a("filter_locked", this.locked);
        compound.func_74774_a("filter_type", this.filter_type);
        return compound;
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.tickInterval;
        this.openCount = FilteredChestTile.getOpenCount(this.field_145850_b, this, this.tickInterval, i, j, k, this.openCount);
        this.previousOpenness = this.openness;
        if (this.openCount > 0 && this.openness == 0.0f) {
            this.playSound(SoundEvents.field_187657_V);
        }
        if (this.openCount == 0 && this.openness > 0.0f || this.openCount > 0 && this.openness < 1.0f) {
            float f1 = this.openness;
            this.openness = this.openCount > 0 ? (this.openness += 0.1f) : (this.openness -= 0.1f);
            if (this.openness > 1.0f) {
                this.openness = 1.0f;
            }
            if (this.openness < 0.5f && f1 >= 0.5f) {
                this.playSound(SoundEvents.field_187651_T);
            }
            if (this.openness < 0.0f) {
                this.openness = 0.0f;
            }
        }
    }

    private void playSound(SoundEvent p_195483_1_) {
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184148_a((PlayerEntity)null, d0, d1, d2, p_195483_1_, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.openCount = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.signalOpenCount();
        }
    }

    public void func_174886_c(PlayerEntity p_174886_1_) {
        if (!p_174886_1_.func_175149_v()) {
            --this.openCount;
            this.signalOpenCount();
        }
    }

    protected void signalOpenCount() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof FilteredChestBase) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.openCount);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public NonNullList<ItemStack> getFilter() {
        return this.filter;
    }

    public static int getOpenCount(IBlockReader world, BlockPos pos) {
        TileEntity tileentity;
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.hasTileEntity() && (tileentity = world.func_175625_s(pos)) instanceof FilteredChestTile) {
            return ((FilteredChestTile)tileentity).openCount;
        }
        return 0;
    }

    public static int getOpenCount(World world, LockableTileEntity tile, int tick, int posX, int posY, int posZ, int count) {
        if (!world.field_72995_K && count != 0 && (tick + posX + posY + posZ) % 200 == 0) {
            count = FilteredChestTile.getOpenCount(world, tile, posX, posY, posZ);
        }
        return count;
    }

    public static int getOpenCount(World world, LockableTileEntity tile, int posX, int posY, int posZ) {
        int i = 0;
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)posX - 5.0f), (double)((float)posY - 5.0f), (double)((float)posZ - 5.0f), (double)((float)(posX + 1) + 5.0f), (double)((float)(posY + 1) + 5.0f), (double)((float)(posZ + 1) + 5.0f)))) {
            IInventory iinventory;
            if (!(playerentity.field_71070_bA instanceof FilteredChestContainer) || (iinventory = ((FilteredChestContainer)playerentity.field_71070_bA).getInventory()) != tile && (!(iinventory instanceof DoubleSidedInventory) || !((DoubleSidedInventory)iinventory).func_90010_a((IInventory)tile))) continue;
            ++i;
        }
        return i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float value) {
        return MathHelper.func_219799_g((float)value, (float)this.previousOpenness, (float)this.openness);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.handler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.handler;
            this.handler = null;
            oldHandler.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.handler == null) {
                this.handler = LazyOptional.of(this::createHandler);
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this){

            public int getSlots() {
                return ((FilteredChestTile)this.getInv()).getRealSize();
            }
        };
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.handler != null) {
            this.handler.invalidate();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.isItemValid(stack);
    }

    public boolean isItemValid(ItemStack stack) {
        for (ItemStack filterStack : this.filter) {
            if (!(this.filter_type == 0 && stack.func_77973_b().equals(filterStack.func_77973_b()) || this.filter_type == 1 && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)filterStack)) && (this.filter_type != 2 || !FilterUtils.allowdedIn(stack.func_77973_b(), filterStack.func_77973_b().func_77640_w()))) continue;
            return !this.blacklist;
        }
        return this.blacklist;
    }

    public boolean isBlackListed() {
        return this.blacklist;
    }

    public void switchBlackListed() {
        this.blacklist = !this.blacklist;
    }

    public boolean isFilterLocked() {
        return this.locked;
    }

    public void switchLocked() {
        this.locked = !this.locked;
    }

    public byte getFilterType() {
        return this.filter_type;
    }

    public void nextFilterType() {
        this.filter_type = (byte)((this.filter_type + 1) % 3);
    }

    public int[] func_180463_a(Direction p_180463_1_) {
        return this.chesttype.getSidedSlots();
    }

    public boolean func_180462_a(int slot, ItemStack stack, Direction face) {
        return true;
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction face) {
        return true;
    }
}

