/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.forge;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.atesab.customcursormod.common.CursorMod;
import fr.atesab.customcursormod.common.config.CursorConfig;
import fr.atesab.customcursormod.common.cursor.CursorClick;
import fr.atesab.customcursormod.common.cursor.CursorType;
import fr.atesab.customcursormod.common.cursor.SelectZone;
import fr.atesab.customcursormod.common.gui.GuiConfig;
import fr.atesab.customcursormod.common.handler.CommonButton;
import fr.atesab.customcursormod.common.handler.CommonElement;
import fr.atesab.customcursormod.common.handler.CommonScreen;
import fr.atesab.customcursormod.common.handler.CommonShaders;
import fr.atesab.customcursormod.common.handler.CommonTextField;
import fr.atesab.customcursormod.common.handler.GameType;
import fr.atesab.customcursormod.common.handler.GuiUtils;
import fr.atesab.customcursormod.common.handler.ResourceLocationCommon;
import fr.atesab.customcursormod.common.handler.StringCommonText;
import fr.atesab.customcursormod.common.handler.TranslationCommonText;
import fr.atesab.customcursormod.common.utils.I18n;
import fr.atesab.customcursormod.forge.ForgeBasicCommonScreen;
import fr.atesab.customcursormod.forge.ForgeCommonButton;
import fr.atesab.customcursormod.forge.ForgeCommonScreen;
import fr.atesab.customcursormod.forge.ForgeCommonShaders;
import fr.atesab.customcursormod.forge.ForgeCommonTextField;
import fr.atesab.customcursormod.forge.ForgeGuiUtils;
import fr.atesab.customcursormod.forge.ForgeResourceLocationCommon;
import fr.atesab.customcursormod.forge.ForgeStringCommonTextImpl;
import fr.atesab.customcursormod.forge.ForgeTranslationCommonTextImpl;
import fr.atesab.customcursormod.forge.gui.ForgeGuiSelectZone;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import net.minecraftforge.fmlclient.gui.screen.ModListScreen;
import net.minecraftforge.fmlclient.gui.widget.ModListWidget;
import net.minecraftforge.forgespi.language.IModInfo;

@OnlyIn(value=Dist.CLIENT)
@Mod(value="customcursormod")
public class ForgeCursorMod {
    private CursorMod mod = new CursorMod(GameType.FORGE);

    public ForgeCursorMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, parent) -> ((ForgeCommonScreen)GuiConfig.create(new ForgeBasicCommonScreen((Screen)parent))).getHandle()));
    }

    private void checkModList(Screen screen) {
        Optional op;
        IModInfo info;
        ModListWidget.ModEntry entry;
        if (screen != null && screen instanceof ModListScreen && (entry = this.getFirstFieldOfTypeInto(ModListWidget.ModEntry.class, screen)) != null && (info = entry.getInfo()) != null && (op = ModList.get().getModContainerById(info.getModId())).isPresent()) {
            boolean value = ((ModContainer)op.get()).getCustomExtension(ConfigGuiHandler.ConfigGuiFactory.class).isPresent();
            String configText = net.minecraft.client.resources.language.I18n.m_118938_((String)"fml.menu.mods.config", (Object[])new Object[0]);
            for (GuiEventListener b : screen.m_6702_()) {
                if (!(b instanceof Button) || !((Button)b).m_6035_().getString().equals(configText)) continue;
                ((Button)b).f_93623_ = value;
            }
        }
    }

    private List<Field[]> getDeclaredField(Class<?> cls) {
        ArrayList<Field[]> l = new ArrayList<Field[]>();
        l.add(cls.getDeclaredFields());
        while (!cls.equals(Object.class)) {
            cls = cls.getSuperclass();
            l.add(cls.getDeclaredFields());
        }
        return l;
    }

    private <T> T getFirstFieldOfTypeInto(Class<T> cls, Object obj) {
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.getType() != cls) continue;
            try {
                return (T)f.get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private boolean isHover(int mouseX, int mouseY, int x, int y, int width, int height) {
        x = Math.min(x + width, x);
        y = Math.min(y + height, y);
        width = Math.abs(width);
        height = Math.abs(height);
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private boolean isHoverButton(int mouseX, int mouseY, AbstractButton button) {
        return button != null && button.f_93624_ && button.f_93623_ && this.isHover(mouseX, mouseY, button.f_93620_, button.f_93621_, button.m_5711_(), button.m_93694_());
    }

    private boolean isHoverTextField(int mouseX, int mouseY, EditBox textField) {
        return textField != null && textField.m_94213_() && this.isHover(mouseX, mouseY, textField.f_93620_, textField.f_93621_, textField.m_5711_(), textField.m_93694_());
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post ev) {
        Screen gui = ev.getGui();
        CursorType newCursorType = CursorType.POINTER;
        if (this.mod.getConfig().dynamicCursor) {
            Object cs;
            Screen screen = gui;
            if (screen instanceof ForgeCommonScreen.ForgeCommonScreenHandler) {
                ForgeCommonScreen.ForgeCommonScreenHandler handle = (ForgeCommonScreen.ForgeCommonScreenHandler)screen;
                cs = handle.cs;
                for (CommonElement commonElement : ((CommonScreen)cs).childrens) {
                    if (!commonElement.isEnable() || !commonElement.isHover(ev.getMouseX(), ev.getMouseY())) continue;
                    if (commonElement instanceof CommonTextField) {
                        newCursorType = CursorType.BEAM;
                        continue;
                    }
                    if (commonElement instanceof CommonButton) {
                        newCursorType = CursorType.HAND;
                        continue;
                    }
                    if (!(commonElement instanceof SelectZone)) continue;
                    newCursorType = CursorType.CROSS;
                }
            } else {
                cs = this.getDeclaredField(gui.getClass()).iterator();
                while (cs.hasNext()) {
                    Field[] fa;
                    block4: for (Field f : fa = (Field[])cs.next()) {
                        try {
                            f.setAccessible(true);
                            Object o = f.get(gui);
                            if (o == null) continue;
                            if (o instanceof EditBox) {
                                if (!this.isHoverTextField(ev.getMouseX(), ev.getMouseY(), (EditBox)o)) continue;
                                newCursorType = CursorType.BEAM;
                                continue;
                            }
                            Object object = o;
                            if (object instanceof AbstractButton) {
                                AbstractButton b = (AbstractButton)object;
                                if (!this.isHoverButton(ev.getMouseX(), ev.getMouseY(), b)) continue;
                                newCursorType = CursorType.HAND;
                                continue;
                            }
                            object = o;
                            if (object instanceof SelectZone) {
                                SelectZone selectZone = (SelectZone)object;
                                if (!this.isHover(ev.getMouseX(), ev.getMouseY(), selectZone.getXPosition(), selectZone.getYPosition(), selectZone.getWidth(), selectZone.getHeight()) || !selectZone.isEnable()) continue;
                                newCursorType = CursorType.CROSS;
                                continue;
                            }
                            if (!(o instanceof Iterable)) continue;
                            for (Object e : (Iterable)o) {
                                Object t = e;
                                if (t instanceof AbstractButton) {
                                    AbstractButton b = (AbstractButton)t;
                                    if (!this.isHoverButton(ev.getMouseX(), ev.getMouseY(), b)) continue;
                                    newCursorType = CursorType.HAND;
                                    continue;
                                }
                                t = e;
                                if (t instanceof EditBox) {
                                    EditBox b = (EditBox)t;
                                    if (!this.isHoverTextField(ev.getMouseX(), ev.getMouseY(), b)) continue;
                                    newCursorType = CursorType.BEAM;
                                    continue;
                                }
                                t = e;
                                if (!(t instanceof SelectZone)) continue block4;
                                SelectZone selectZone = (SelectZone)t;
                                if (!selectZone.isHover(ev.getMouseX(), ev.getMouseY()) || !selectZone.isEnable()) continue;
                                newCursorType = CursorType.CROSS;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if ((cs = gui) instanceof AbstractContainerScreen) {
                AbstractContainerScreen container = (AbstractContainerScreen)cs;
                if (gui.getMinecraft().f_91074_.f_36096_.m_142621_() != null && !gui.getMinecraft().f_91074_.f_36096_.m_142621_().m_41720_().equals(Items.f_41852_)) {
                    newCursorType = CursorType.HAND_GRAB;
                } else if (container.getSlotUnderMouse() != null && container.getSlotUnderMouse().m_6657_()) {
                    newCursorType = CursorType.HAND;
                }
            } else if (gui instanceof ChatScreen) {
                Minecraft mc = gui.getMinecraft();
                int mx = (int)(mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_());
                int n = (int)(mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_());
                Style style = mc.f_91065_.m_93076_().m_93800_((double)mx, (double)n);
                if (style != null && style.m_131182_() != null) {
                    newCursorType = CursorType.HAND;
                }
            }
            for (CursorType cursorType : this.mod.getCursors().keySet()) {
                if (cursorType.getCursorTester() == null || !cursorType.getCursorTester().testCursor(newCursorType, gui, ev.getMouseX(), ev.getMouseY(), ev.getRenderPartialTicks())) continue;
                newCursorType = cursorType;
                break;
            }
        }
        this.mod.changeCursor(newCursorType);
        if (this.mod.getConfig().clickAnimation) {
            Iterator<CursorClick> iterator = this.mod.getCursorClicks().iterator();
            while (iterator.hasNext()) {
                CursorClick cursorClick = iterator.next();
                int posX = (int)cursorClick.getPosX();
                int n = (int)cursorClick.getPosY();
                ForgeGuiUtils.getForge().setShader(ForgeCommonShaders.getForge().getPositionTexShader());
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("textures/gui/click_" + (2 - cursorClick.getTime() / 3) + ".png"));
                ForgeGuiUtils.getForge().drawScaledCustomSizeModalRect(posX - 8, n - 8, 0.0f, 0.0f, 16, 16, 16, 16, 16.0f, 16.0f, -1, true);
                cursorClick.descreaseTime();
                if (cursorClick.getTime() > 0) continue;
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public void onGuiCloses(TickEvent ev) {
        if (!this.mod.getCursorClicks().isEmpty() && Minecraft.m_91087_().f_91080_ == null) {
            this.mod.getCursorClicks().clear();
        }
    }

    @SubscribeEvent
    public void onGuiCloses(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            this.checkModList(Minecraft.m_91087_().f_91080_);
            this.mod.waiter.tick();
        }
    }

    @SubscribeEvent
    public void onInitScreen(GuiScreenEvent.InitGuiEvent.Post ev) {
        this.mod.forceNextCursor();
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre ev) {
        if (ev.getButton() == 0 && this.mod.getConfig().clickAnimation) {
            this.mod.getCursorClicks().add(new CursorClick(6, ev.getMouseX(), ev.getMouseY()));
        }
    }

    private void setup(FMLLoadCompleteEvent ev) {
        File saveDir = new File(Minecraft.m_91087_().f_91069_, "config");
        saveDir.mkdirs();
        File save = new File(saveDir, "customcursormod.json");
        this.mod.getConfig().sync(save);
        this.mod.getConfig().sync(save);
        this.mod.getCursors().values().forEach(CursorConfig::getCursor);
        this.mod.loadData(Minecraft.m_91087_().m_91268_().m_85439_());
    }

    static {
        SelectZone.SUPPLIER.forType(GameType.FORGE, o -> new ForgeGuiSelectZone(o.xPosition, o.yPosition, o.width, o.height));
        GuiUtils.SUPPLIER.forType(GameType.FORGE, ForgeGuiUtils::getForge);
        TranslationCommonText.SUPPLIER.forType(GameType.FORGE, obj -> new ForgeTranslationCommonTextImpl(obj.format, obj.args));
        StringCommonText.SUPPLIER.forType(GameType.FORGE, ForgeStringCommonTextImpl::new);
        ResourceLocationCommon.SUPPLIER.forType(GameType.FORGE, ForgeResourceLocationCommon::new);
        CommonButton.SUPPLIER.forType(GameType.FORGE, ForgeCommonButton::new);
        CommonTextField.SUPPLIER.forType(GameType.FORGE, ForgeCommonTextField::new);
        CommonScreen.SUPPLIER.forType(GameType.FORGE, ForgeCommonScreen::new);
        CommonScreen.SUPPLIER_CURRENT.forType(GameType.FORGE, v -> new ForgeBasicCommonScreen(Minecraft.m_91087_().f_91080_));
        I18n.SUPPLIER.forType(GameType.FORGE, obj -> net.minecraft.client.resources.language.I18n.m_118938_((String)obj.format, (Object[])obj.args));
        CommonShaders.SUPPLIER.forType(GameType.FORGE, ForgeCommonShaders::getForge);
    }
}

