/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common;

import fr.atesab.customcursormod.common.config.Configuration;
import fr.atesab.customcursormod.common.config.CursorConfig;
import fr.atesab.customcursormod.common.cursor.CursorClick;
import fr.atesab.customcursormod.common.cursor.CursorType;
import fr.atesab.customcursormod.common.gui.GuiWaiter;
import fr.atesab.customcursormod.common.handler.GameType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;

public class CursorMod {
    private static CursorMod instance;
    public static final String MOD_ID = "customcursormod";
    public static final String MOD_NAME = "Custom Cursor Mod";
    public static final String MOD_VERSION = "1.3.0.1";
    public static final String MOD_AUTHORS = "ATE47, KevinFernandezDominguez";
    public static final String MOD_LICENCE = "GNU GPL 3";
    public static final Logger logger;
    public final GuiWaiter waiter = new GuiWaiter();
    private boolean forceNextCursor;
    private CursorType currentCursorType;
    private Map<CursorType, CursorConfig> cursors;
    private List<CursorClick> cursorClicks;
    private Configuration config;
    private GameType type;
    private long windowHandle;

    public static CursorMod getInstance() {
        return instance;
    }

    public CursorMod(GameType type) {
        instance = this;
        this.type = type;
        this.forceNextCursor = false;
        this.currentCursorType = CursorType.POINTER;
        this.cursors = new HashMap<CursorType, CursorConfig>();
        this.cursorClicks = new ArrayList<CursorClick>();
        this.config = new Configuration();
        this.registerCursor(this.currentCursorType, CursorType.HAND, CursorType.HAND_GRAB, CursorType.BEAM, CursorType.CROSS);
    }

    public GameType getType() {
        return this.type;
    }

    public void loadData(long windowHandle) {
        this.windowHandle = windowHandle;
    }

    public void changeCursor(CursorType cursor) {
        this.changeCursor(cursor, this.forceNextCursor);
        this.forceNextCursor = false;
    }

    private void changeCursor(CursorType cursor, boolean forceChange) {
        if (!forceChange && cursor == this.currentCursorType) {
            return;
        }
        this.currentCursorType = cursor;
        CursorConfig cursorConfig = this.cursors.getOrDefault(cursor, cursor.getDefaultConfig());
        long cursorPtr = cursorConfig.getCursor();
        if (cursorPtr == 0L) {
            throw new NullPointerException();
        }
        GLFW.glfwSetCursor((long)this.windowHandle, (long)cursorPtr);
    }

    public void forceNextCursor() {
        this.forceNextCursor = this.config.dynamicCursor;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Map<CursorType, CursorConfig> getCursors() {
        return this.cursors;
    }

    public void registerCursor(CursorType ... cursorTypes) {
        for (CursorType cursorType : cursorTypes) {
            this.cursors.put(cursorType, cursorType.getDefaultConfig());
        }
    }

    public void replaceCursor(CursorType type, CursorConfig config) {
        CursorConfig old = this.cursors.put(type, config);
        if (type == this.currentCursorType) {
            this.changeCursor(type, true);
        }
        if (old.isAllocate()) {
            old.freeCursor();
        }
    }

    public void saveConfig() {
        this.config.save();
    }

    public List<CursorClick> getCursorClicks() {
        return this.cursorClicks;
    }

    static {
        logger = Logger.getLogger(MOD_NAME);
    }
}

