/*
 * Decompiled with CFR 0.152.
 */
package com.camscorner.icarus.client.renderers;

import com.camscorner.icarus.client.models.DiscordsWingsModel;
import com.camscorner.icarus.client.models.FeatheredWingModel;
import com.camscorner.icarus.client.models.FlandresWingsModel;
import com.camscorner.icarus.client.models.LeatherWingModel;
import com.camscorner.icarus.client.models.LightWingsModel;
import com.camscorner.icarus.client.models.WingEntityModel;
import com.camscorner.icarus.client.models.ZanzasWingsModel;
import com.camscorner.icarus.common.items.WingItem;
import com.camscorner.icarus.core.mixins.DyeColourAccessor;
import dev.emi.trinkets.api.TrinketsApi;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_918;

public class WingsFeatureRenderer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private WingEntityModel<T> wingModel = new WingEntityModel();

    public WingsFeatureRenderer(class_3883<T, M> context) {
        super(context);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_1799 stack;
        if (entity instanceof class_1657 && (stack = TrinketsApi.getTrinketComponent((class_1657)((class_1657)entity)).getStack("chest", "cape")).method_7909() instanceof WingItem) {
            String wingType;
            WingItem wingItem = (WingItem)stack.method_7909();
            int primaryColour = ((DyeColourAccessor)wingItem.getPrimaryColour()).getColour();
            int secondaryColour = ((DyeColourAccessor)wingItem.getSecondaryColour()).getColour();
            float r1 = (float)(primaryColour >> 16 & 0xFF) / 255.0f;
            float g1 = (float)(primaryColour >> 8 & 0xFF) / 255.0f;
            float b1 = (float)(primaryColour & 0xFF) / 255.0f;
            float r2 = (float)(secondaryColour >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(secondaryColour >> 8 & 0xFF) / 255.0f;
            float b2 = (float)(secondaryColour & 0xFF) / 255.0f;
            String string = wingType = wingItem.getWingType() != WingItem.WingType.UNIQUE ? wingItem.getWingType().toString().toLowerCase() : class_2378.field_11142.method_10221((Object)wingItem).method_12832().replaceAll("_wings", "");
            if (wingItem.getWingType() == WingItem.WingType.FEATHERED || wingItem.getWingType() == WingItem.WingType.MECHANICAL_FEATHERED) {
                this.wingModel = new FeatheredWingModel();
            }
            if (wingItem.getWingType() == WingItem.WingType.DRAGON || wingItem.getWingType() == WingItem.WingType.MECHANICAL_LEATHER) {
                this.wingModel = new LeatherWingModel();
            }
            if (wingItem.getWingType() == WingItem.WingType.LIGHT) {
                this.wingModel = new LightWingsModel();
            }
            if (wingType.equals("flandres")) {
                this.wingModel = new FlandresWingsModel();
            }
            if (wingType.equals("discords")) {
                this.wingModel = new DiscordsWingsModel();
            }
            if (wingType.equals("zanzas")) {
                this.wingModel = new ZanzasWingsModel();
            }
            class_2960 layer1 = new class_2960("icarus", "textures/entity/" + wingType + "_wings.png");
            class_2960 layer2 = new class_2960("icarus", "textures/entity/" + wingType + "_wings_2.png");
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 0.125);
            this.method_17165().method_17081(this.wingModel);
            this.wingModel.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            this.renderWings(matrices, vertexConsumers, stack, layer2, light, r2, g2, b2);
            this.renderWings(matrices, vertexConsumers, stack, layer1, light, r1, g1, b1);
            matrices.method_22909();
        }
    }

    public void renderWings(class_4587 matrices, class_4597 vertexConsumers, class_1799 stack, class_2960 layerName, int light, float r, float g, float b) {
        class_4588 vertexConsumer = class_918.method_27952((class_4597)vertexConsumers, (class_1921)class_1921.method_23580((class_2960)layerName), (boolean)false, (boolean)stack.method_7958());
        this.wingModel.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, r, g, b, 1.0f);
    }
}

