/*
 * Decompiled with CFR 0.152.
 */
package com.camscorner.icarus.common.items;

import com.camscorner.icarus.Icarus;
import com.camscorner.icarus.core.network.client.DeleteHungerMessage;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.TrinketItem;
import java.util.UUID;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import top.theillusivec4.caelus.api.CaelusApi;

public class WingItem
extends TrinketItem {
    private Multimap<class_1320, class_1322> attributeModifiers;
    private ImmutableMultimap.Builder<class_1320, class_1322> builder = ImmutableMultimap.builder();
    private class_1767 primaryColour;
    private class_1767 secondaryColour;
    private WingType wingType;
    private boolean shouldSlowfall;
    private static final class_3494<class_1792> FREE_FLIGHT = TagRegistry.item((class_2960)new class_2960("icarus", "free_flight"));
    private static final class_3494<class_1792> MELTS = TagRegistry.item((class_2960)new class_2960("icarus", "melts"));
    private double speed;
    private double acceleration;

    public WingItem(double speed, double acceleration, class_1767 primaryColour, class_1767 secondaryColour, WingType wingType) {
        super(new class_1792.class_1793().method_7892(Icarus.ITEM_GROUP).method_7889(1).method_7895(Icarus.config.wingsDurability).method_7894(wingType == WingType.UNIQUE ? class_1814.field_8904 : class_1814.field_8903));
        this.builder.put((Object)CaelusApi.ELYTRA_FLIGHT, (Object)new class_1322(UUID.fromString("7d9704a0-383f-11eb-adc1-0242ac120002"), "Flight", 1.0, class_1322.class_1323.field_6328));
        this.attributeModifiers = this.builder.build();
        this.speed = speed;
        this.acceleration = acceleration;
        this.primaryColour = primaryColour;
        this.secondaryColour = secondaryColour;
        this.wingType = wingType;
    }

    public WingItem(class_1767 primaryColour, class_1767 secondaryColour, WingType wingType) {
        super(new class_1792.class_1793().method_7892(Icarus.ITEM_GROUP).method_7889(1).method_7895(Icarus.config.wingsDurability).method_7894(wingType == WingType.UNIQUE ? class_1814.field_8904 : class_1814.field_8903));
        this.builder.put((Object)CaelusApi.ELYTRA_FLIGHT, (Object)new class_1322(UUID.fromString("7d9704a0-383f-11eb-adc1-0242ac120002"), "Flight", 1.0, class_1322.class_1323.field_6328));
        this.attributeModifiers = this.builder.build();
        this.speed = Icarus.config.wingsSpeed;
        this.acceleration = Icarus.config.wingsAcceleration;
        this.primaryColour = primaryColour;
        this.secondaryColour = secondaryColour;
        this.wingType = wingType;
    }

    public void tick(class_1657 player, class_1799 stack) {
        if (player.method_7344().method_7586() <= 6) {
            return;
        }
        if (player.method_6128()) {
            if (player.field_6250 > 0.0f) {
                this.applySpeed(player);
            }
            if (player.method_5715()) {
                this.stopFlying(player);
            }
            if (player.method_19538().field_1351 > (double)(player.field_6002.method_8322() + 64) && player.field_6012 % 20 == 0 && MELTS.method_15141((Object)this)) {
                stack.method_7956(1, (class_1309)player, p -> p.method_20235(class_1304.field_6174));
            }
        } else {
            if (player.method_24828() || player.method_5799()) {
                this.shouldSlowfall = false;
            }
            if (this.shouldSlowfall) {
                player.field_6017 = 0.0f;
                player.method_18800(player.method_18798().field_1352, -0.4, player.method_18798().field_1350);
            }
        }
    }

    public boolean canWearInSlot(String group, String slot) {
        return group.equals("chest") && slot.equals("cape");
    }

    public Multimap<class_1320, class_1322> getTrinketModifiers(String group, String slot, UUID uuid, class_1799 stack) {
        return this.attributeModifiers;
    }

    public class_1767 getPrimaryColour() {
        return this.primaryColour;
    }

    public class_1767 getSecondaryColour() {
        return this.secondaryColour;
    }

    public WingType getWingType() {
        return this.wingType;
    }

    public void stopFlying(class_1657 player) {
        this.shouldSlowfall = true;
        player.method_23670();
    }

    public void applySpeed(class_1657 player) {
        this.shouldSlowfall = false;
        class_243 rotation = player.method_5720();
        class_243 velocity = player.method_18798();
        float modifier = Icarus.config.armourSlows ? class_3532.method_15363((float)((float)player.method_6096() / 10.0f), (float)1.0f, (float)Icarus.config.maxSlowedMultiplier) : 1.0f;
        player.method_18799(velocity.method_1031(rotation.field_1352 * (this.speed / (double)modifier) + (rotation.field_1352 * 1.5 - velocity.field_1352) * this.acceleration, rotation.field_1351 * (this.speed / (double)modifier) + (rotation.field_1351 * 1.5 - velocity.field_1351) * this.acceleration, rotation.field_1350 * (this.speed / (double)modifier) + (rotation.field_1350 * 1.5 - velocity.field_1350) * this.acceleration));
        if (!FREE_FLIGHT.method_15141((Object)this) && !player.method_7337()) {
            DeleteHungerMessage.send();
        }
    }

    public static enum WingType {
        FEATHERED,
        DRAGON,
        MECHANICAL_FEATHERED,
        MECHANICAL_LEATHER,
        LIGHT,
        UNIQUE;

    }
}

