/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ArmorConfigScreen;
import dlovin.inventoryhud.gui.config.InventoryConfigScreen;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.widgets.ConfigWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.Color4F;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class InGameConfigScreen
extends Screen {
    private final ResourceLocation INV_BG = new ResourceLocation("inventoryhud", "textures/gui/inv_config_bg.png");
    private final ResourceLocation CONF_BG = new ResourceLocation("inventoryhud", "textures/gui/conf_bg.png");
    private ConfigWidget ICW;
    private ConfigWidget PCW;
    private ConfigWidget ACW;
    private List<ConfigWidget> listForRender;
    private Button backButton;
    private final int menu;
    private final boolean inGame;

    public InGameConfigScreen(int menu, boolean inGame) {
        super((Component)new TranslatableComponent("InventoryHUD Config Screen"));
        this.inGame = inGame;
        this.menu = menu;
    }

    protected void m_7856_() {
        int pw;
        float potScale;
        this.listForRender = new ArrayList<ConfigWidget>();
        float invScale = (Boolean)InventoryHUD.getClient().invMini.get() != false ? 0.75f : 1.0f;
        int invWidth = (Boolean)InventoryHUD.getClient().invVert.get() != false ? 52 : 160;
        int invHeight = (Boolean)InventoryHUD.getClient().invVert.get() != false ? 160 : 52;
        int x = this.getPosX((int)((float)invWidth * invScale), (Integer)InventoryHUD.getClient().xPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().invHalign.get()));
        int y = this.getPosY((int)((float)invHeight * invScale), (Integer)InventoryHUD.getClient().yPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().invValign.get()));
        this.backButton = new Button(this.f_96543_ - 60, 10, 50, 20, (Component)new TextComponent("Back"), btn -> this.m_7379_());
        this.ICW = new ConfigWidget(x, y, invWidth, invHeight, invScale, Translation.INVGUI, InventoryHUD.isActive);
        this.listForRender.add(this.ICW);
        if (!((Boolean)InventoryHUD.getClient().invVert.get()).booleanValue()) {
            this.ICW.initTextureValues(0, 0, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        } else {
            this.ICW.initTextureValues(150, 54, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        }
        this.ICW.addListener(w -> this.onInvChanged());
        this.ICW.addPosListener(w -> this.onInvPosChanged());
        float f = ((Boolean)InventoryHUD.getClient().potMini.get()).booleanValue() ? (((Boolean)InventoryHUD.getClient().potHor.get()).booleanValue() ? 1.0f : 0.75f) : (potScale = 1.0f);
        int n = ((Boolean)InventoryHUD.getClient().potHor.get()).booleanValue() ? (((Boolean)InventoryHUD.getClient().potMini.get()).booleanValue() ? 18 : 36) : (pw = 60);
        int ph = ((Boolean)InventoryHUD.getClient().potHor.get()).booleanValue() ? (((Boolean)InventoryHUD.getClient().potMini.get()).booleanValue() ? 22 : 38) : 24;
        x = this.getPosX((int)((float)pw * potScale), (Integer)InventoryHUD.getClient().xPotionPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().potHalign.get()));
        y = this.getPosY((int)((float)ph * potScale), (Integer)InventoryHUD.getClient().yPotionPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().potValign.get()));
        this.PCW = new ConfigWidget(x, y, pw, ph, potScale, Translation.POTGUI, InventoryHUD.potionHUD);
        this.listForRender.add(this.PCW);
        this.PCW.initTextureValues(0, 54, new Color4F(1.0f, 0.5f, 0.5f, 1.0f), this.INV_BG);
        this.PCW.addListener(w -> this.onPotionChanged());
        this.PCW.addPosListener(w -> this.onPotionPosChanged());
        float armScale = (float)((Integer)InventoryHUD.getClient().armScale.get()).intValue() / 100.0f;
        if (((Boolean)InventoryHUD.getClient().moveAll.get()).booleanValue()) {
            x = this.getPosX((int)(90.0f * armScale), (Integer)InventoryHUD.getClient().xArmPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().armHalign.get()));
            y = this.getPosY((int)(70.0f * armScale), (Integer)InventoryHUD.getClient().yArmPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().armValign.get()));
            this.ACW = new ConfigWidget(x, y, 90, 70, armScale, Translation.ARMGUI, InventoryHUD.armorHUD);
            this.listForRender.add(this.ACW);
            this.ACW.initTextureValues(60, 54, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG);
            this.ACW.addListener(w -> this.onArmorChanged());
            this.ACW.addPosListener(w -> this.onArmorPosChanged());
        } else {
            int xSize = (int)(16.0f * armScale);
            int ySize = (int)(16.0f * armScale);
            int textPos = 80;
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().helmPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().helmHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().helmPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().helmVal.get()));
            ConfigWidget tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClient().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_helmet.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 0));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().chestPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().chestHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().chestPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().chestVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClient().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_chestplate.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 1));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().legPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().legHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().legPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().legVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClient().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_leggings.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 2));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().bootPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().bootHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().bootPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().bootVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClient().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_boots.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 3));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().mainPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().mainHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().mainPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().mainVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClient().showMain.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_main_hand_slot.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 5));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().offPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().offHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().offPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().offVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClient().showOff.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_shield.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 4));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().arrPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().arrHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().arrPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().arrVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClient().showArrows.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_arrows.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 7));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().invPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().invHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().invPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().invVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClient().showInv.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_inventory.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 6));
        }
        this.m_6702_().add(this.backButton);
        this.m_6702_().addAll(this.listForRender);
    }

    private int getPosX(int width, int posX, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = posX;
                break;
            }
            case RIGHT: {
                result = this.f_96543_ - posX;
                break;
            }
            case MIDDLE: {
                result = this.f_96543_ / 2 - width / 2 - posX;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.f_96543_ - width) {
            result = this.f_96543_ - width;
        }
        return result;
    }

    private int getPosY(int height, int posY, WidgetAligns.VAlign hal) {
        int result = 0;
        switch (hal) {
            case TOP: {
                result = posY;
                break;
            }
            case BOTTOM: {
                result = this.f_96544_ - posY;
                break;
            }
            case CENTER: {
                result = this.f_96544_ / 2 - height / 2 - posY;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.f_96544_ - height) {
            result = this.f_96544_ - height;
        }
        return result;
    }

    public void m_6305_(PoseStack mat, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(mat);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.CONF_BG);
        RenderSystem.m_69478_();
        InGameConfigScreen.m_93133_((PoseStack)mat, (int)0, (int)(this.f_96544_ / 3 - 1), (float)this.f_96543_, (float)3.0f, (int)this.f_96543_, (int)3, (int)3, (int)3);
        InGameConfigScreen.m_93133_((PoseStack)mat, (int)0, (int)(this.f_96544_ / 3 * 2 - 1), (float)this.f_96543_, (float)3.0f, (int)this.f_96543_, (int)3, (int)3, (int)3);
        InGameConfigScreen.m_93133_((PoseStack)mat, (int)(this.f_96543_ / 3 - 1), (int)0, (float)3.0f, (float)this.f_96544_, (int)3, (int)this.f_96544_, (int)3, (int)3);
        InGameConfigScreen.m_93133_((PoseStack)mat, (int)(this.f_96543_ / 3 * 2 - 1), (int)0, (float)3.0f, (float)this.f_96544_, (int)3, (int)this.f_96544_, (int)3, (int)3);
        RenderSystem.m_69461_();
        for (ConfigWidget w : this.listForRender) {
            w.m_6305_(mat, mouseX, mouseY, partialTick);
        }
        this.backButton.m_6305_(mat, mouseX, mouseY, partialTick);
    }

    private void onInvChanged() {
        InventoryHUD.isActive = this.ICW.getShow();
        InventoryHUD.getClient().byDefault.set((Object)this.ICW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onInvPosChanged() {
        Minecraft mc = Minecraft.m_91087_();
        if (this.ICW.f_93620_ + this.ICW.m_5711_() / 2 <= mc.f_91080_.f_96543_ / 3) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.invX = this.ICW.f_93620_;
        } else if (this.ICW.f_93620_ + this.ICW.m_5711_() / 2 >= mc.f_91080_.f_96543_ / 3 * 2) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.invX = mc.f_91080_.f_96543_ - this.ICW.f_93620_;
        } else {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.invX = this.ICW.f_93620_ + this.ICW.m_5711_() / 2 <= mc.f_91080_.f_96543_ / 2 - 10 ? mc.f_91080_.f_96543_ / 2 - this.ICW.m_5711_() / 2 - this.ICW.f_93620_ : (this.ICW.f_93620_ + this.ICW.m_5711_() / 2 >= mc.f_91080_.f_96543_ / 2 + 10 ? mc.f_91080_.f_96543_ / 2 - this.ICW.m_5711_() / 2 - this.ICW.f_93620_ : 0);
        }
        if (this.ICW.f_93621_ + this.ICW.m_93694_() / 2 <= mc.f_91080_.f_96544_ / 3) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.invY = this.ICW.f_93621_;
        } else if (this.ICW.f_93621_ + this.ICW.m_93694_() / 2 >= mc.f_91080_.f_96544_ / 3 * 2) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.invY = mc.f_91080_.f_96544_ - this.ICW.f_93621_;
        } else {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.invY = this.ICW.f_93621_ + this.ICW.m_93694_() / 2 <= mc.f_91080_.f_96544_ / 2 - 10 ? mc.f_91080_.f_96544_ / 2 - this.ICW.m_93694_() / 2 - this.ICW.f_93621_ : (this.ICW.f_93621_ + this.ICW.m_93694_() / 2 >= mc.f_91080_.f_96544_ / 2 + 10 ? mc.f_91080_.f_96544_ / 2 - this.ICW.m_93694_() / 2 - this.ICW.f_93621_ : 0);
        }
    }

    private void onPotionChanged() {
        InventoryHUD.potionHUD = this.PCW.getShow();
        InventoryHUD.getClient().Potions.set((Object)this.PCW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onPotionPosChanged() {
        Minecraft mc = Minecraft.m_91087_();
        if (this.PCW.f_93620_ + this.PCW.m_5711_() / 2 <= mc.f_91080_.f_96543_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = this.PCW.f_93620_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else if (this.PCW.f_93620_ + this.PCW.m_5711_() / 2 >= mc.f_91080_.f_96543_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.f_91080_.f_96543_ - this.PCW.f_93620_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            if (this.PCW.f_93620_ + this.PCW.m_5711_() / 2 <= mc.f_91080_.f_96543_ / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.f_91080_.f_96543_ / 2 - this.PCW.m_5711_() / 2 - this.PCW.f_93620_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else if (this.PCW.f_93620_ + this.PCW.m_5711_() / 2 >= mc.f_91080_.f_96543_ / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.f_91080_.f_96543_ / 2 - this.PCW.m_5711_() / 2 - this.PCW.f_93620_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            }
        }
        if (this.PCW.f_93621_ + this.PCW.m_93694_() / 2 <= mc.f_91080_.f_96544_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = this.PCW.f_93621_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
        } else if (this.PCW.f_93621_ + this.PCW.m_93694_() / 2 >= mc.f_91080_.f_96544_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.f_91080_.f_96544_ - this.PCW.f_93621_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            if (this.PCW.f_93621_ + this.PCW.m_93694_() / 2 <= mc.f_91080_.f_96544_ / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.f_91080_.f_96544_ / 2 - this.PCW.m_93694_() / 2 - this.PCW.f_93621_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            } else if (this.PCW.f_93621_ + this.PCW.m_93694_() / 2 >= mc.f_91080_.f_96544_ / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.f_91080_.f_96544_ / 2 - this.PCW.m_93694_() / 2 - this.PCW.f_93621_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            }
        }
    }

    private void onArmorChanged() {
        InventoryHUD.armorHUD = this.ACW.getShow();
        InventoryHUD.getClient().ArmorDamage.set((Object)this.ACW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onArmorPosChanged() {
        int ay;
        int ax;
        Minecraft mc = Minecraft.m_91087_();
        WidgetAligns armal = new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.BOTTOM);
        if (this.ACW.f_93620_ + this.ACW.m_5711_() / 2 <= mc.f_91080_.f_96543_ / 3) {
            armal.HorAlign = WidgetAligns.HAlign.LEFT;
            ax = this.ACW.f_93620_;
        } else if (this.ACW.f_93620_ + this.ACW.m_5711_() / 2 >= mc.f_91080_.f_96543_ / 3 * 2) {
            armal.HorAlign = WidgetAligns.HAlign.RIGHT;
            ax = mc.f_91080_.f_96543_ - this.ACW.f_93620_;
        } else {
            armal.HorAlign = WidgetAligns.HAlign.MIDDLE;
            ax = this.ACW.f_93620_ + this.ACW.m_5711_() / 2 <= mc.f_91080_.f_96543_ / 2 - 10 ? mc.f_91080_.f_96543_ / 2 - this.ACW.m_5711_() / 2 - this.ACW.f_93620_ : (this.ACW.f_93620_ + this.ACW.m_5711_() / 2 >= mc.f_91080_.f_96543_ / 2 + 10 ? mc.f_91080_.f_96543_ / 2 - this.ACW.m_5711_() / 2 - this.ACW.f_93620_ : 0);
        }
        if (this.ACW.f_93621_ + this.ACW.m_93694_() / 2 <= mc.f_91080_.f_96544_ / 2 - 10) {
            armal.VertAlign = WidgetAligns.VAlign.TOP;
            ay = this.ACW.f_93621_;
        } else if (this.ACW.f_93621_ + this.ACW.m_93694_() / 2 >= mc.f_91080_.f_96544_ / 2 + 10) {
            armal.VertAlign = WidgetAligns.VAlign.BOTTOM;
            ay = mc.f_91080_.f_96544_ - this.ACW.f_93621_;
        } else {
            armal.VertAlign = WidgetAligns.VAlign.CENTER;
            ay = this.ACW.f_93621_ + this.ACW.m_93694_() / 2 <= mc.f_91080_.f_96544_ / 2 - 10 ? mc.f_91080_.f_96544_ / 2 - this.ACW.m_93694_() / 2 - this.ACW.f_93621_ : (this.ACW.f_93621_ + this.ACW.m_93694_() / 2 >= mc.f_91080_.f_96544_ / 2 + 10 ? mc.f_91080_.f_96544_ / 2 - this.ACW.m_93694_() / 2 - this.ACW.f_93621_ : 0);
        }
        InventoryHUD.getInstance().getInventoryGui().changeArmorPos(armal, ax, ay);
    }

    private void onItemPosChanged(ConfigWidget w, int i) {
        Minecraft mc = Minecraft.m_91087_();
        if (w.f_93620_ + w.m_5711_() / 2 <= mc.f_91080_.f_96543_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = w.f_93620_;
        } else if (w.f_93620_ + w.m_5711_() / 2 >= mc.f_91080_.f_96543_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = mc.f_91080_.f_96543_ - w.f_93620_;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = w.f_93620_ + w.m_5711_() / 2 <= mc.f_91080_.f_96543_ / 2 - 10 ? mc.f_91080_.f_96543_ / 2 - w.m_5711_() / 2 - w.f_93620_ : (w.f_93620_ + w.m_5711_() / 2 >= mc.f_91080_.f_96543_ / 2 + 10 ? mc.f_91080_.f_96543_ / 2 - w.m_5711_() / 2 - w.f_93620_ : 0);
        }
        if (w.f_93621_ + w.m_93694_() / 2 <= mc.f_91080_.f_96544_ / 2 - 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = w.f_93621_;
        } else if (w.f_93621_ + w.m_93694_() / 2 >= mc.f_91080_.f_96544_ / 2 + 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = mc.f_91080_.f_96544_ - w.f_93621_;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = w.f_93621_ + w.m_93694_() / 2 <= mc.f_91080_.f_96544_ / 2 - 10 ? mc.f_91080_.f_96544_ / 2 - w.m_93694_() / 2 - w.f_93621_ : (w.f_93621_ + w.m_93694_() / 2 >= mc.f_91080_.f_96544_ / 2 + 10 ? mc.f_91080_.f_96544_ / 2 - w.m_93694_() / 2 - w.f_93621_ : 0);
        }
    }

    private void saveConfig() {
        InventoryHUD.getClient().xPos.set((Object)InventoryGui.invX);
        InventoryHUD.getClient().yPos.set((Object)InventoryGui.invY);
        InventoryHUD.getClient().invHalign.set((Object)InventoryGui.InvAligns.HorAlign);
        InventoryHUD.getClient().invValign.set((Object)InventoryGui.InvAligns.VertAlign);
        InventoryHUD.getClient().xPotionPos.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX);
        InventoryHUD.getClient().yPotionPos.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY);
        InventoryHUD.getClient().potHalign.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign);
        InventoryHUD.getClient().potValign.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign);
        InventoryHUD.getClient().xArmPos.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.armX);
        InventoryHUD.getClient().yArmPos.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.armY);
        InventoryHUD.getClient().armHalign.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.HorAlign);
        InventoryHUD.getClient().armValign.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.VertAlign);
        InventoryHUD.getClient().helmPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].x);
        InventoryHUD.getClient().chestPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].x);
        InventoryHUD.getClient().legPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].x);
        InventoryHUD.getClient().bootPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].x);
        InventoryHUD.getClient().offPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].x);
        InventoryHUD.getClient().mainPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].x);
        InventoryHUD.getClient().invPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].x);
        InventoryHUD.getClient().arrPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].x);
        InventoryHUD.getClient().helmPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].y);
        InventoryHUD.getClient().chestPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].y);
        InventoryHUD.getClient().legPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].y);
        InventoryHUD.getClient().bootPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].y);
        InventoryHUD.getClient().offPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].y);
        InventoryHUD.getClient().mainPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].y);
        InventoryHUD.getClient().invPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].y);
        InventoryHUD.getClient().arrPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].y);
        InventoryHUD.getClient().helmHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.HorAlign);
        InventoryHUD.getClient().chestHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.HorAlign);
        InventoryHUD.getClient().legHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.HorAlign);
        InventoryHUD.getClient().bootHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.HorAlign);
        InventoryHUD.getClient().offHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.HorAlign);
        InventoryHUD.getClient().mainHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.HorAlign);
        InventoryHUD.getClient().invHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.HorAlign);
        InventoryHUD.getClient().arrHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.HorAlign);
        InventoryHUD.getClient().helmVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.VertAlign);
        InventoryHUD.getClient().chestVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.VertAlign);
        InventoryHUD.getClient().legVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.VertAlign);
        InventoryHUD.getClient().bootVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.VertAlign);
        InventoryHUD.getClient().offVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.VertAlign);
        InventoryHUD.getClient().mainVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.VertAlign);
        InventoryHUD.getClient().invVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.VertAlign);
        InventoryHUD.getClient().arrVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.VertAlign);
        InventoryHUD.getConfig().clientSpec.save();
    }

    public void m_7379_() {
        this.saveConfig();
        switch (this.menu) {
            case -1: {
                this.f_96541_.m_91152_(null);
                break;
            }
            case 0: {
                this.f_96541_.m_91152_((Screen)new InventoryConfigScreen(this.inGame));
                break;
            }
            case 1: {
                this.f_96541_.m_91152_((Screen)new ArmorConfigScreen(this.inGame));
                break;
            }
            case 2: {
                this.f_96541_.m_91152_((Screen)new PotionConfigScreen(this.inGame));
            }
        }
    }
}

