/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.ChatFormatting;

public class PotionConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton MiniModeBtn;
    private CustomButton HorModeBtn;
    private NumericTextField AlphaField;
    private NumericTextField GapField;

    public PotionConfigScreen(boolean inGame) {
        super(2, inGame);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        String toggle = (Boolean)InventoryHUD.getConfig().getClient().Potions.get() != false ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.f_96543_ / 2 + 20, 0, 40, 20, toggle, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.ToggleBtn.addListener(this::ToggleSwitch);
        this.MiniModeBtn = new CustomButton(this.f_96543_ / 2 + 20, 0, 40, 20, ((Boolean)InventoryHUD.getConfig().getClient().potMini.get()).toString(), null, false);
        this.OptionList.addWidget(this.MiniModeBtn, 2);
        this.MiniModeBtn.addListener(this::MiniModeSwitch);
        this.HorModeBtn = new CustomButton(this.f_96543_ / 2 + 20, 0, 40, 20, ((Boolean)InventoryHUD.getConfig().getClient().potHor.get()).toString(), null, false);
        this.OptionList.addWidget(this.HorModeBtn, 3);
        this.HorModeBtn.addListener(this::HorModeSwitch);
        this.AlphaField = new NumericTextField(this.f_96547_, this.f_96543_ / 2 + 20, 0, 40, 20, 0, 100, (Integer)InventoryHUD.getConfig().getClient().potAlpha.get(), tf -> this.AlphaChanged());
        this.OptionList.addWidget(this.AlphaField, 1);
        this.GapField = new NumericTextField(this.f_96547_, this.f_96543_ / 2 + 20, 0, 40, 20, -5, 5, (Integer)InventoryHUD.getConfig().getClient().potGap.get(), tf -> this.GapChanged());
        this.OptionList.addWidget(this.GapField, 4);
        this.AlphaField.setMaxStringLength(5);
        this.GapField.setMaxStringLength(3);
        this.OptionList.addWidget(new TextWidget(this.f_96543_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_TOGGLE.getString(), this.f_96547_, (w, m, x, y) -> this.m_96602_(m, Translation.POT_TOGGLE_TT, x, y)), 0);
        this.OptionList.addWidget(new TextWidget(this.f_96543_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_ALPHA.getString(), this.f_96547_, (w, m, x, y) -> this.m_96602_(m, Translation.POT_ALPHA_TT, x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.f_96543_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_MINI.getString(), this.f_96547_, (w, m, x, y) -> this.m_96602_(m, Translation.POT_MINI_TT, x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.f_96543_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_HOR.getString(), this.f_96547_, (w, m, x, y) -> this.m_96602_(m, Translation.POT_HOR_TT, x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.f_96543_ / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_GAP.getString(), this.f_96547_, (w, m, x, y) -> this.m_96602_(m, Translation.POT_GAP_TT, x, y)), 4);
    }

    private void HorModeSwitch() {
        Boolean hor = (Boolean)InventoryHUD.getConfig().getClient().potHor.get() == false;
        InventoryHUD.getConfig().getClient().potHor.set((Object)hor);
        InventoryHUD.getConfig().clientSpec.save();
        InventoryHUD.getInstance().getInventoryGui().changePotionHor(hor);
        this.HorModeBtn.setMessage(hor.toString());
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
    }

    private void AlphaChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AlphaField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.potAlpha = (float)a / 100.0f;
        InventoryHUD.getConfig().getClient().potAlpha.set((Object)a);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void GapChanged() {
        int a;
        try {
            a = Integer.parseInt(this.GapField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.potGap = a;
        InventoryHUD.getConfig().getClient().potGap.set((Object)a);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ToggleSwitch() {
        Boolean potion = (Boolean)InventoryHUD.getConfig().getClient().Potions.get() == false;
        InventoryHUD.potionHUD = potion;
        InventoryHUD.getConfig().getClient().Potions.set((Object)potion);
        String toggle = potion != false ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        this.ToggleBtn.setMessage(toggle);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void MiniModeSwitch() {
        Boolean mini = (Boolean)InventoryHUD.getConfig().getClient().potMini.get() == false;
        InventoryHUD.getConfig().getClient().potMini.set((Object)mini);
        InventoryHUD.getConfig().clientSpec.save();
        InventoryHUD.getInstance().getInventoryGui().changePotionMini(mini);
        this.MiniModeBtn.setMessage(mini.toString());
        InventoryHUD.getConfig().clientSpec.save();
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
    }
}

