/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;

public class BlockArmorRenderer
extends ArmorRenderer {
    private boolean right;

    public BlockArmorRenderer(Minecraft mc) {
        super(mc);
    }

    public void changeOffset() {
        this.right = this.getRight(this.armX, this.ArmAligns.HorAlign);
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        float scale = (float)this.armScale / 100.0f;
        int x = this.getX(width, (int)(90.0f * scale), this.armX, this.ArmAligns.HorAlign);
        int y = this.getY(height, (int)(70.0f * scale), this.armY, this.ArmAligns.VertAlign);
        mat.m_85836_();
        mat.m_85837_((double)x, (double)y, -320.0);
        mat.m_85841_(scale, scale, 1.0f);
        this.RenderItems(mat, x, y, this.right, scale);
        mat.m_85849_();
    }

    private void RenderItems(PoseStack mat, int x, int y, boolean right, float scale) {
        int i = 5;
        int xOffsetT = right ? 75 : 0;
        for (ItemStack item : this.mc.f_91074_.m_20158_()) {
            if (!this.showMain && i == 5) {
                --i;
                continue;
            }
            if (!this.showOff && i == 4) {
                --i;
                continue;
            }
            if (!this.showArmor && i < 4) {
                --i;
                continue;
            }
            int yOffset = i % 4 * 18;
            if (i == 4 && this.showMain) {
                yOffset += 18;
            }
            if (i == 5) {
                yOffset -= 18;
            }
            int xOffset = xOffsetT;
            if (i > 3 && this.showArmor) {
                xOffset = right ? xOffset - 42 : xOffset + 42;
            }
            int Damage = ArmorStatus.GetDamage(item);
            String text = null;
            if (Damage >= 0 && Damage <= this.armAbove) {
                if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    switch (this.armView) {
                        case PERCENTAGE: {
                            text = this.getDamageText(String.valueOf(Damage), Damage);
                            break;
                        }
                        case DAMAGE: {
                            text = this.getDamageText(String.valueOf(item.m_41773_()), Damage);
                            break;
                        }
                        case DAMAGE_LEFT: {
                            text = this.getDamageText(String.valueOf(item.m_41776_() - item.m_41773_()), Damage);
                        }
                    }
                }
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, null, item, text, this.armBars);
            } else if (Damage == -2) {
                String t = null;
                boolean over = true;
                if ((i == 5 || i == 4) && this.showCount) {
                    t = "" + this.getItemCount(item);
                    over = false;
                }
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, null, item, t, over);
            } else if (this.showEmpty) {
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, this.armorRL[i], null, null, false);
            }
            --i;
        }
        if (this.showArrows || this.showInv) {
            int count = 0;
            int arrows = 0;
            for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35974_) {
                if (slot.m_41619_()) {
                    ++count;
                }
                if (!this.isArrow(slot)) continue;
                arrows += slot.m_41613_();
            }
            int xOffset = xOffsetT;
            int yOffset = 36;
            if (this.showArmor) {
                int n = xOffset = right ? xOffset - 42 : xOffset + 42;
            }
            if (!this.showMain) {
                yOffset -= 18;
            }
            if (!this.showOff) {
                yOffset -= 18;
            }
            if (this.showInv) {
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, this.armorRL[6], null, "" + count, false);
                yOffset += 18;
            }
            if (this.showArrows) {
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, this.armorRL[7], null, "" + arrows, false);
            }
        }
    }
}

