/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class VerticalMiniPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_mini.png");

    public VerticalMiniPotionRenderer(Minecraft mc) {
        super(mc);
    }

    private int getX(int width) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 22 - this.potX;
                    break;
                }
                result = width / 2 - 11 - this.potX;
                break;
            }
            case RIGHT: {
                result = width - this.potX + 23;
            }
        }
        return result;
    }

    private int getY(int height, int effCount) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    result = height / 2 - 9 - this.potY;
                    break;
                }
                if (this.potY < 0) {
                    result = height / 2 - 9 - (effCount - 1) * (18 + this.potGap) - this.potY;
                    break;
                }
                result = (int)((float)(height / 2 - 9) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 9.0f) - (float)this.potY);
                break;
            }
            case BOTTOM: {
                result = height - this.potY - (effCount - 1) * (this.potGap + 18);
            }
        }
        return result;
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        int y = 0;
        int effCount = this.mc.f_91074_.m_21220_().size();
        if (effCount == 0) {
            return;
        }
        MobEffectTextureManager potionspriteuploader = this.mc.m_91306_();
        mat.m_85836_();
        mat.m_85837_(0.0, 0.0, -255.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        int xPos = this.getX(width);
        int yPos = this.getY(height, effCount);
        for (MobEffectInstance effect : this.mc.f_91074_.m_21220_()) {
            MobEffect pot = effect.m_19544_();
            mat.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            RenderSystem.m_69478_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.PBG);
            VerticalMiniPotionRenderer.m_93133_((PoseStack)mat, (int)xPos, (int)(yPos + y), (float)22.0f, (float)18.0f, (int)22, (int)18, (int)(22 * this.potSide), (int)18);
            RenderSystem.m_69461_();
            mat.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite textureatlassprite = potionspriteuploader.m_118732_(pot);
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
            VerticalMiniPotionRenderer.m_93200_((PoseStack)mat, (int)(xPos + 3 + this.potIconSide), (int)(yPos + y + 3), (int)this.m_93252_(), (int)12, (int)12, (TextureAtlasSprite)textureatlassprite);
            ResourceLocation lev = effect.m_19564_() < 9 && effect.m_19564_() >= 0 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.m_19564_() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            RenderSystem.m_157456_((int)0, (ResourceLocation)lev);
            VerticalMiniPotionRenderer.m_93133_((PoseStack)mat, (int)(xPos + 9 + this.potIconSide), (int)(yPos + y), (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
            int dur = effect.m_19557_() / 20;
            int ysize = 12;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.PMT);
            RenderSystem.m_157429_((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            if (dur < 300) {
                float r = 1.0f;
                float g = 1.0f;
                ysize = dur / 25 + 1;
                if (dur < 150) {
                    g = 0.006666667f * (float)dur;
                } else {
                    r = 0.006666667f * (float)(300 - dur);
                }
                RenderSystem.m_157429_((float)r, (float)g, (float)0.0f, (float)1.0f);
            }
            VerticalMiniPotionRenderer.m_93133_((PoseStack)mat, (int)(xPos + 17 + this.potTextSide), (int)(yPos + y + 15 - ysize), (float)3.0f, (float)ysize, (int)3, (int)ysize, (int)3, (int)ysize);
            y += 18 + this.potGap;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        mat.m_85849_();
    }
}

