/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class VerticalPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg.png");

    public VerticalPotionRenderer(Minecraft mc) {
        super(mc);
    }

    private int getX(int width) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                result = width / 2 - 30 - this.potX;
                break;
            }
            case RIGHT: {
                result = width - this.potX;
            }
        }
        return result;
    }

    private int getY(int height, int effCount) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    result = height / 2 - 12 - this.potY;
                    break;
                }
                if (this.potY < 0) {
                    result = height / 2 - 12 - (effCount - 1) * (24 + this.potGap) - this.potY;
                    break;
                }
                result = (int)((float)(height / 2 - 12) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 12.0f) - (float)this.potY);
                break;
            }
            case BOTTOM: {
                result = height - this.potY - (effCount - 1) * (this.potGap + 24);
            }
        }
        return result;
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        int y = 0;
        int effCount = this.mc.f_91074_.m_21220_().size();
        if (effCount == 0) {
            return;
        }
        MobEffectTextureManager potionspriteuploader = this.mc.m_91306_();
        mat.m_85836_();
        mat.m_85837_(0.0, 0.0, -255.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        int xPos = this.getX(width);
        int yPos = this.getY(height, effCount);
        for (MobEffectInstance effect : this.mc.f_91074_.m_21220_()) {
            MobEffect pot = effect.m_19544_();
            mat.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            RenderSystem.m_69478_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.PBG);
            VerticalPotionRenderer.m_93133_((PoseStack)mat, (int)xPos, (int)(yPos + y), (float)60.0f, (float)24.0f, (int)60, (int)24, (int)(60 * this.potSide), (int)24);
            RenderSystem.m_69461_();
            mat.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite textureatlassprite = potionspriteuploader.m_118732_(pot);
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
            VerticalPotionRenderer.m_93200_((PoseStack)mat, (int)(xPos + 3 + this.potIconSide), (int)(yPos + y + 3), (int)this.m_93252_(), (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            ResourceLocation lev = effect.m_19564_() < 9 && effect.m_19564_() >= 0 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.m_19564_() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            RenderSystem.m_157456_((int)0, (ResourceLocation)lev);
            VerticalPotionRenderer.m_93133_((PoseStack)mat, (int)(xPos + 15 + this.potIconSide), (int)(yPos + y), (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
            Object time = "";
            int dur = effect.m_19557_() / 20;
            if (dur > 1600) {
                time = " **:**";
            } else {
                String mins = "" + dur / 60;
                String secs = "" + dur % 60;
                if (dur / 60 < 10) {
                    mins = "0" + mins;
                }
                if (dur % 60 < 10) {
                    secs = "0" + secs;
                }
                time = dur > 10 ? mins + ":" + secs : ChatFormatting.RED + mins + ChatFormatting.WHITE + ":" + ChatFormatting.RED + secs;
            }
            this.fontRenderer.m_92750_(mat, (String)time, (float)(xPos + 28 + this.potTextSide), (float)(yPos + y + 8), 0xFFFFFF);
            y += 24 + this.potGap;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        mat.m_85849_();
    }
}

