/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import mcp.mobius.waila.api.RenderableTextComponent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import snownee.jade.util.HackyRenderableTextComponent;
import snownee.jade.util.HackyTextComponentNBT;

public final class Renderables {
    static final ResourceLocation ITEM = new ResourceLocation("item");
    static final ResourceLocation SPACER = new ResourceLocation("spacer");
    static final ResourceLocation OFFSET_TEXT = new ResourceLocation("jade", "text");
    static final ResourceLocation BORDER = new ResourceLocation("jade", "border");

    private Renderables() {
    }

    public static RenderableTextComponent item(ItemStack stack) {
        if (!stack.func_190926_b()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("id", stack.func_77973_b().getRegistryName().toString());
            tag.func_74768_a("count", stack.func_190916_E());
            if (stack.func_77942_o()) {
                tag.func_74778_a("nbt", stack.func_77978_p().toString());
            }
            return new RenderableTextComponent(ITEM, tag);
        }
        return Renderables.spacer(18, 0);
    }

    public static RenderableTextComponent offsetText(ITextComponent s, int x, int y) {
        return Renderables.offsetText(s.func_150254_d(), x, y);
    }

    public static RenderableTextComponent offsetText(String s, int x, int y) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("text", s);
        tag.func_74768_a("x", x);
        tag.func_74768_a("y", y);
        return new RenderableTextComponent(OFFSET_TEXT, tag);
    }

    public static RenderableTextComponent spacer(int width, int height) {
        CompoundNBT spacerTag = new CompoundNBT();
        spacerTag.func_74768_a("width", width);
        spacerTag.func_74768_a("height", height);
        return new RenderableTextComponent(SPACER, spacerTag);
    }

    public static RenderableTextComponent box(ITextComponent ... components) {
        CompoundNBT tag = new CompoundNBT();
        ListNBT renderData = new ListNBT();
        for (ITextComponent component : components) {
            renderData.add((Object)new HackyTextComponentNBT(component));
        }
        tag.func_218657_a("in", (INBT)renderData);
        return new HackyRenderableTextComponent(BORDER, tag);
    }

    public static RenderableTextComponent of(RenderableTextComponent ... components) {
        return new RenderableTextComponent(components);
    }
}

