/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.RenderableTextComponent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.EnderChestTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import snownee.jade.JadeCommonConfig;
import snownee.jade.JadePlugin;
import snownee.jade.Renderables;

public class InventoryProvider
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    public static final InventoryProvider INSTANCE = new InventoryProvider();
    public static final Set<String> INVENTORY_IGNORE = Collections.synchronizedSet(Sets.newHashSet());

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (!config.get(JadePlugin.INVENTORY) || accessor.getTileEntity() == null || accessor.getTileEntity() instanceof AbstractFurnaceTileEntity) {
            return;
        }
        if (accessor.getServerData().func_74764_b("Locked") && accessor.getServerData().func_74767_n("Locked")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("jade.locked", new Object[0]));
            return;
        }
        if (accessor.getServerData().func_74764_b("jadeHandler")) {
            ItemStack stack;
            ItemStack stack2;
            ItemStackHandler itemHandler = new ItemStackHandler();
            itemHandler.deserializeNBT(accessor.getServerData().func_74775_l("jadeHandler"));
            int drawnCount = 0;
            int realSize = 0;
            for (int i = 0; i < itemHandler.getSlots() && !(stack2 = itemHandler.getStackInSlot(i)).func_190926_b(); ++i) {
                ++realSize;
            }
            boolean showName = realSize < 5;
            ArrayList components = Lists.newArrayList();
            for (int i = 0; i < itemHandler.getSlots() && !(stack = itemHandler.getStackInSlot(i)).func_190926_b(); ++i) {
                if (i > 0 && (showName || drawnCount >= JadeCommonConfig.inventoryShowItemPreLine)) {
                    tooltip.add((ITextComponent)Renderables.of(components.toArray(new RenderableTextComponent[0])));
                    components.clear();
                    drawnCount = 0;
                }
                components.add(Renderables.item(stack));
                if (showName) {
                    components.add(Renderables.offsetText(stack.func_200301_q(), 0, 4));
                }
                ++drawnCount;
            }
            if (!components.isEmpty()) {
                tooltip.add((ITextComponent)Renderables.of(components.toArray(new RenderableTextComponent[0])));
            }
        }
    }

    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World world, TileEntity te) {
        LockableTileEntity lockableTileEntity;
        int size;
        if (te == null || JadeCommonConfig.shouldIgnoreTE(tag.func_74779_i("id")) || te instanceof AbstractFurnaceTileEntity) {
            return;
        }
        int n = size = player.func_213453_ef() ? JadeCommonConfig.inventorySneakShowAmount : JadeCommonConfig.inventoryNormalShowAmount;
        if (size == 0) {
            return;
        }
        if (!(JadeCommonConfig.bypassLockedContainer || player.func_184812_l_() || player.func_175149_v() || !(te instanceof LockableTileEntity) || (lockableTileEntity = (LockableTileEntity)te).func_213904_e((PlayerEntity)player))) {
            tag.func_74757_a("Locked", true);
            return;
        }
        IItemHandler itemHandler = null;
        LazyOptional optional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (optional.isPresent()) {
            itemHandler = (IItemHandler)optional.orElse(null);
        } else if (te instanceof IInventory) {
            itemHandler = new InvWrapper((IInventory)te);
        } else if (te instanceof EnderChestTileEntity) {
            itemHandler = new InvWrapper((IInventory)player.func_71005_bN());
        }
        if (itemHandler != null) {
            size = Math.min(size, itemHandler.getSlots());
            ItemStackHandler mergedHandler = new ItemStackHandler(size);
            boolean empty = true;
            for (int i = 0; i < size; ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                empty = false;
                ItemHandlerHelper.insertItemStacked((IItemHandler)mergedHandler, (ItemStack)stack.func_77946_l(), (boolean)false);
            }
            if (!empty) {
                tag.func_218657_a("jadeHandler", (INBT)mergedHandler.serializeNBT());
            }
        }
    }
}

