/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Collection;
import java.util.List;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import snownee.jade.JadePlugin;
import snownee.jade.Renderables;

public class PotionEffectsProvider
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    public static final PotionEffectsProvider INSTANCE = new PotionEffectsProvider();

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!config.get(JadePlugin.EFFECTS) || !accessor.getServerData().func_74764_b("Potions")) {
            return;
        }
        ListNBT list = accessor.getServerData().func_150295_c("Potions", 10);
        ITextComponent[] lines = new ITextComponent[list.size()];
        for (int i = 0; i < lines.length; ++i) {
            CompoundNBT compound = list.func_150305_b(i);
            int duration = compound.func_74762_e("Duration");
            TranslationTextComponent name = new TranslationTextComponent(compound.func_74779_i("Name"), new Object[0]);
            TranslationTextComponent amplifier = new TranslationTextComponent("potion.potency." + compound.func_74762_e("Amplifier"), new Object[0]);
            TranslationTextComponent s = new TranslationTextComponent("jade.potion", new Object[]{name, amplifier, PotionEffectsProvider.getPotionDurationString(duration)});
            lines[i] = s.func_211708_a(compound.func_74767_n("Bad") ? TextFormatting.RED : TextFormatting.GREEN);
        }
        tooltip.add((ITextComponent)Renderables.box(lines));
    }

    public static String getPotionDurationString(int duration) {
        if (duration == Short.MAX_VALUE) {
            return "**:**";
        }
        int i = MathHelper.func_76141_d((float)duration);
        return PotionEffectsProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World arg2, Entity entity) {
        LivingEntity living = (LivingEntity)entity;
        Collection effects = living.func_70651_bq();
        if (effects.isEmpty()) {
            return;
        }
        ListNBT list = new ListNBT();
        for (EffectInstance effect : effects) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("Name", effect.func_76453_d());
            compound.func_74768_a("Amplifier", effect.func_76458_c());
            compound.func_74768_a("Duration", effect.func_76459_b());
            compound.func_74757_a("Bad", !effect.func_188419_a().func_188408_i());
            list.add((Object)compound);
        }
        tag.func_218657_a("Potions", (INBT)list);
    }
}

