/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.jade.JadePlugin;

public class TrappedChestProvider
implements IComponentProvider {
    public static final TrappedChestProvider INSTANCE = new TrappedChestProvider();
    private static final Cache<Block, ITextComponent> CACHE = CacheBuilder.newBuilder().build();
    private static final ITextComponent DEFAULT_NAME = new TranslationTextComponent(Blocks.field_150486_ae.func_149739_a(), new Object[0]);

    public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (!config.get(JadePlugin.TRAPPED_CHEST)) {
            return;
        }
        try {
            ITextComponent name = (ITextComponent)CACHE.get((Object)accessor.getBlock(), () -> {
                ResourceLocation chestName;
                Block block;
                ResourceLocation trappedName = accessor.getBlock().getRegistryName();
                if (trappedName.func_110623_a().startsWith("trapped_") && (block = (Block)ForgeRegistries.BLOCKS.getValue(chestName = new ResourceLocation(trappedName.func_110624_b(), trappedName.func_110623_a().substring(8)))) != null) {
                    return block.func_200291_n();
                }
                return DEFAULT_NAME;
            });
            tooltip.clear();
            tooltip.add((ITextComponent)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getBlockName(), name.func_150254_d())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

