/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.client.renderer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.overlay.Tooltip;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.util.HackyTextComponentNBT;

@OnlyIn(value=Dist.CLIENT)
public class BoxTooltipRenderer
implements ITooltipRenderer {
    private final Cache<CompoundNBT, Tooltip> cachedTooltips = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private static Field FIELD_SIZE;

    public Dimension getSize(CompoundNBT nbt, ICommonAccessor accessor) {
        Tooltip tooltip = this.geTooltip(nbt);
        try {
            Dimension dimension = new Dimension((Dimension)FIELD_SIZE.get(tooltip));
            dimension.height += 4;
            dimension.width += 2;
            return dimension;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return new Dimension();
        }
    }

    public void draw(CompoundNBT nbt, ICommonAccessor accessor, int x, int y) {
        Tooltip tooltip = this.geTooltip(nbt);
        if (tooltip != null) {
            Rectangle rect = tooltip.getPosition();
            RenderSystem.enableBlend();
            int color = Color.GRAY.getRGB();
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)x, (float)y, (float)0.0f);
            AbstractGui.fill((int)0, (int)0, (int)1, (int)rect.height, (int)color);
            AbstractGui.fill((int)0, (int)0, (int)rect.width, (int)1, (int)color);
            AbstractGui.fill((int)rect.width, (int)0, (int)(rect.width + 1), (int)rect.height, (int)color);
            AbstractGui.fill((int)0, (int)rect.height, (int)(rect.width + 1), (int)(rect.height + 1), (int)color);
            RenderSystem.translatef((float)(-x), (float)(-rect.y), (float)0.0f);
            tooltip.draw();
            RenderSystem.popMatrix();
        }
    }

    private Tooltip geTooltip(CompoundNBT nbt) {
        try {
            return (Tooltip)this.cachedTooltips.get((Object)nbt, () -> {
                ListNBT tags = nbt.func_150295_c("in", 8);
                List components = tags.stream().map(tag -> ((HackyTextComponentNBT)((Object)((Object)tag))).getTextComponent()).collect(Collectors.toList());
                return new Tooltip(components, false);
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return new Tooltip(Collections.EMPTY_LIST, false);
        }
    }

    static {
        try {
            FIELD_SIZE = Tooltip.class.getDeclaredField("totalSize");
            FIELD_SIZE.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

