/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.minecraft;

import java.util.List;
import mcp.mobius.waila.addons.minecraft.PluginMinecraft;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.RenderableTextComponent;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class HUDHandlerFurnace
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    static final HUDHandlerFurnace INSTANCE = new HUDHandlerFurnace();

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (!config.get(PluginMinecraft.CONFIG_DISPLAY_FURNACE)) {
            return;
        }
        int progressInt = accessor.getServerData().func_74762_e("progress");
        if (progressInt == 0) {
            return;
        }
        ListNBT furnaceItems = accessor.getServerData().func_150295_c("furnace", 10);
        NonNullList inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < furnaceItems.size(); ++i) {
            inventory.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)furnaceItems.func_150305_b(i)));
        }
        CompoundNBT progress = new CompoundNBT();
        progress.func_74768_a("progress", progressInt);
        progress.func_74768_a("total", accessor.getServerData().func_74762_e("total"));
        RenderableTextComponent renderables = new RenderableTextComponent(HUDHandlerFurnace.getRenderable((ItemStack)inventory.get(0)), HUDHandlerFurnace.getRenderable((ItemStack)inventory.get(1)), new RenderableTextComponent(PluginMinecraft.RENDER_FURNACE_PROGRESS, progress), HUDHandlerFurnace.getRenderable((ItemStack)inventory.get(2)));
        tooltip.add((ITextComponent)renderables);
    }

    @Override
    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, TileEntity blockEntity) {
        AbstractFurnaceTileEntity furnace = (AbstractFurnaceTileEntity)blockEntity;
        ListNBT items = new ListNBT();
        items.add((Object)furnace.func_70301_a(0).func_77955_b(new CompoundNBT()));
        items.add((Object)furnace.func_70301_a(1).func_77955_b(new CompoundNBT()));
        items.add((Object)furnace.func_70301_a(2).func_77955_b(new CompoundNBT()));
        data.func_218657_a("furnace", (INBT)items);
        CompoundNBT furnaceTag = furnace.func_189515_b(new CompoundNBT());
        data.func_74768_a("progress", furnaceTag.func_74762_e("CookTime"));
        data.func_74768_a("total", furnaceTag.func_74762_e("CookTimeTotal"));
    }

    private static RenderableTextComponent getRenderable(ItemStack stack) {
        if (!stack.func_190926_b()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("id", stack.func_77973_b().getRegistryName().toString());
            tag.func_74768_a("count", stack.func_190916_E());
            if (stack.func_77942_o()) {
                tag.func_74778_a("nbt", stack.func_77978_p().toString());
            }
            return new RenderableTextComponent(PluginMinecraft.RENDER_ITEM, tag);
        }
        CompoundNBT spacerTag = new CompoundNBT();
        spacerTag.func_74768_a("width", 18);
        return new RenderableTextComponent(PluginMinecraft.RENDER_SPACER, spacerTag);
    }
}

