/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class RenderableTextComponent
extends StringTextComponent {
    public RenderableTextComponent(ResourceLocation id, CompoundNBT data) {
        super(RenderableTextComponent.getRenderString(id, data));
    }

    public RenderableTextComponent(RenderableTextComponent ... components) {
        this((ITextComponent[])components);
    }

    public RenderableTextComponent(ITextComponent ... components) {
        super(RenderableTextComponent.getRenderString(components));
    }

    public List<RenderContainer> getRenderers() {
        ArrayList renderers = Lists.newArrayList();
        CompoundNBT data = this.getData();
        if (data.func_74764_b("renders")) {
            ListNBT list = data.func_150295_c("renders", 8);
            list.forEach(t -> {
                StringNBT stringTag = (StringNBT)t;
                try {
                    CompoundNBT tag = JsonToNBT.func_180713_a((String)stringTag.func_150285_a_());
                    ResourceLocation id = new ResourceLocation(tag.func_74779_i("id"));
                    CompoundNBT dataTag = tag.func_74775_l("data");
                    renderers.add(new RenderContainer(id, dataTag));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            });
        } else {
            ResourceLocation id = new ResourceLocation(data.func_74779_i("id"));
            CompoundNBT dataTag = data.func_74775_l("data");
            renderers.add(new RenderContainer(id, dataTag));
        }
        return renderers;
    }

    private CompoundNBT getData() {
        try {
            return JsonToNBT.func_180713_a((String)this.getString());
        }
        catch (CommandSyntaxException e) {
            return new CompoundNBT();
        }
    }

    public IFormattableTextComponent func_230529_a_(ITextComponent sibling) {
        throw new UnsupportedOperationException();
    }

    private static String getRenderString(ResourceLocation id, CompoundNBT data) {
        CompoundNBT renderData = new CompoundNBT();
        renderData.func_74778_a("id", id.toString());
        renderData.func_218657_a("data", (INBT)data);
        return renderData.toString();
    }

    private static String getRenderString(ITextComponent ... components) {
        CompoundNBT container = new CompoundNBT();
        ListNBT renderData = new ListNBT();
        for (ITextComponent component : components) {
            if (component instanceof RenderableTextComponent) {
                CompoundNBT data = ((RenderableTextComponent)component).getData();
                if (data.func_74764_b("renders")) {
                    renderData.addAll((Collection)data.func_150295_c("renders", 8));
                    continue;
                }
                renderData.add((Object)StringNBT.func_229705_a_((String)component.getString()));
                continue;
            }
            renderData.add((Object)StringNBT.func_229705_a_((String)RenderableTextComponent.getNormalString(component)));
        }
        container.func_218657_a("renders", (INBT)renderData);
        return container.toString();
    }

    private static String getNormalString(ITextComponent component) {
        CompoundNBT data = new CompoundNBT();
        data.func_74778_a("text", ITextComponent.Serializer.func_150696_a((ITextComponent)component));
        CompoundNBT renderData = new CompoundNBT();
        renderData.func_74778_a("id", PluginCore.RENDER_TEXT.toString());
        renderData.func_218657_a("data", (INBT)data);
        return renderData.toString();
    }

    public static class RenderContainer {
        private final ResourceLocation id;
        private final CompoundNBT data;
        private final ITooltipRenderer renderer;

        public RenderContainer(ResourceLocation id, CompoundNBT data) {
            this.id = id;
            this.data = data;
            this.renderer = WailaRegistrar.INSTANCE.getTooltipRenderer(id);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public CompoundNBT getData() {
            return this.data;
        }

        public ITooltipRenderer getRenderer() {
            return this.renderer;
        }
    }
}

