/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import mcp.mobius.waila.api.impl.config.HUDTheme;
import net.minecraft.client.Minecraft;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import org.apache.commons.lang3.StringEscapeUtils;

public class WailaConfig {
    private final ConfigGeneral general = new ConfigGeneral();
    private final ConfigOverlay overlay = new ConfigOverlay();
    private final ConfigFormatting formatting = new ConfigFormatting();

    public ConfigGeneral getGeneral() {
        return this.general;
    }

    public ConfigOverlay getOverlay() {
        return this.overlay;
    }

    public ConfigFormatting getFormatting() {
        return this.formatting;
    }

    public static enum DisplayMode {
        HOLD_KEY,
        TOGGLE;

    }

    public static class ConfigFormatting {
        private String modName = StringEscapeUtils.escapeJava((String)"\u00a79\u00a7o%s");
        private String blockName = StringEscapeUtils.escapeJava((String)"\u00a7f%s");
        private String fluidName = StringEscapeUtils.escapeJava((String)"\u00a7f%s");
        private String entityName = StringEscapeUtils.escapeJava((String)"\u00a7f%s");
        private String registryName = StringEscapeUtils.escapeJava((String)"\u00a77[%s]");

        public void setModName(String modName) {
            this.modName = modName;
        }

        public void setBlockName(String blockName) {
            this.blockName = blockName;
        }

        public void setFluidName(String fluidName) {
            this.fluidName = fluidName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public String getModName() {
            return StringEscapeUtils.unescapeJava((String)this.modName);
        }

        public String getBlockName() {
            return StringEscapeUtils.unescapeJava((String)this.blockName);
        }

        public String getFluidName() {
            return StringEscapeUtils.unescapeJava((String)this.fluidName);
        }

        public String getEntityName() {
            return StringEscapeUtils.unescapeJava((String)this.entityName);
        }

        public String getRegistryName() {
            return StringEscapeUtils.unescapeJava((String)this.registryName);
        }
    }

    public static class ConfigOverlay {
        private float overlayPosX = 0.5f;
        private float overlayPosY = 0.99f;
        private float overlayAnchorX = 0.5f;
        private float overlayAnchorY = 0.0f;
        private boolean overlaySquare = false;
        private boolean flipMainHand = false;
        private ConfigOverlayColor color = new ConfigOverlayColor();

        public void setOverlayPosX(float overlayPosX) {
            this.overlayPosX = MathHelper.func_76131_a((float)overlayPosX, (float)0.0f, (float)1.0f);
        }

        public void setOverlayPosY(float overlayPosY) {
            this.overlayPosY = MathHelper.func_76131_a((float)overlayPosY, (float)0.0f, (float)1.0f);
        }

        public void setOverlayScale(float overlayScale) {
        }

        public void setAnchorX(float overlayAnchorX) {
            this.overlayAnchorX = MathHelper.func_76131_a((float)overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        public void setAnchorY(float overlayAnchorY) {
            this.overlayAnchorY = MathHelper.func_76131_a((float)overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        public float getOverlayPosX() {
            return MathHelper.func_76131_a((float)this.overlayPosX, (float)0.0f, (float)1.0f);
        }

        public float getOverlayPosY() {
            return MathHelper.func_76131_a((float)this.overlayPosY, (float)0.0f, (float)1.0f);
        }

        public float getOverlayScale() {
            return 1.0f;
        }

        public float getAnchorX() {
            return MathHelper.func_76131_a((float)this.overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        public float getAnchorY() {
            return MathHelper.func_76131_a((float)this.overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        public void setFlipMainHand(boolean overlaySquare) {
            this.flipMainHand = overlaySquare;
        }

        public boolean getFlipMainHand() {
            return this.flipMainHand;
        }

        public float tryFlip(float f) {
            if (Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.LEFT) {
                f = 1.0f - f;
            }
            return f;
        }

        public void setSquare(boolean overlaySquare) {
            this.overlaySquare = overlaySquare;
        }

        public boolean getSquare() {
            return this.overlaySquare;
        }

        public ConfigOverlayColor getColor() {
            return this.color;
        }

        public static class ConfigOverlayColor {
            private int alpha = 50;
            private Map<ResourceLocation, HUDTheme> themes = Maps.newHashMap();
            private ResourceLocation activeTheme = HUDTheme.DARK.getId();

            public ConfigOverlayColor() {
                this.themes.put(HUDTheme.VANILLA.getId(), HUDTheme.VANILLA);
                this.themes.put(HUDTheme.DARK.getId(), HUDTheme.DARK);
            }

            public int getAlpha() {
                return MathHelper.func_76125_a((int)((int)((float)this.alpha / 100.0f * 256.0f)), (int)0, (int)255) << 24;
            }

            public int getRawAlpha() {
                return this.alpha;
            }

            public HUDTheme getTheme() {
                return this.themes.getOrDefault(this.activeTheme, HUDTheme.VANILLA);
            }

            public Collection<HUDTheme> getThemes() {
                return this.themes.values();
            }

            public void setAlpha(int alpha) {
                this.alpha = alpha;
            }

            public int getBackgroundColor() {
                return this.getAlpha() + this.getTheme().getBackgroundColor();
            }

            public int getGradientStart() {
                return this.getAlpha() + this.getTheme().getGradientStart();
            }

            public int getGradientEnd() {
                return this.getAlpha() + this.getTheme().getGradientEnd();
            }

            public int getFontColor() {
                return this.getTheme().getFontColor();
            }

            public void applyTheme(ResourceLocation id) {
                this.activeTheme = this.themes.containsKey(id) ? id : this.activeTheme;
            }

            public static class Adapter
            implements JsonSerializer<ConfigOverlayColor>,
            JsonDeserializer<ConfigOverlayColor> {
                public ConfigOverlayColor deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject json = element.getAsJsonObject();
                    ConfigOverlayColor color = new ConfigOverlayColor();
                    color.alpha = json.getAsJsonPrimitive("alpha").getAsInt();
                    color.activeTheme = new ResourceLocation(json.getAsJsonPrimitive("activeTheme").getAsString());
                    color.themes = Maps.newHashMap();
                    json.getAsJsonArray("themes").forEach(e -> {
                        HUDTheme theme = (HUDTheme)context.deserialize(e, HUDTheme.class);
                        color.themes.put(theme.getId(), theme);
                    });
                    return color;
                }

                public JsonElement serialize(ConfigOverlayColor src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject json = new JsonObject();
                    json.addProperty("alpha", (Number)src.alpha);
                    json.add("themes", context.serialize(src.themes.values()));
                    json.addProperty("activeTheme", src.activeTheme.toString());
                    return json;
                }
            }
        }
    }

    public static class ConfigGeneral {
        private boolean displayTooltip = true;
        private boolean shiftForDetails = false;
        private DisplayMode displayMode = DisplayMode.TOGGLE;
        private boolean hideFromDebug = true;
        private boolean showItem = true;
        private boolean enableTextToSpeech = false;
        private int maxHealthForRender = 40;
        private int maxHeartsPerLine = 10;
        private RayTraceContext.FluidMode fluldMode = RayTraceContext.FluidMode.NONE;
        private float reachDistance = 0.0f;

        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        public void setShiftForDetails(boolean shiftForDetails) {
            this.shiftForDetails = shiftForDetails;
        }

        public void setDisplayMode(DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        public void setShowItem(boolean showItem) {
            this.showItem = showItem;
        }

        public void setEnableTextToSpeech(boolean enableTextToSpeech) {
            this.enableTextToSpeech = enableTextToSpeech;
        }

        public void setMaxHealthForRender(int maxHealthForRender) {
            this.maxHealthForRender = maxHealthForRender;
        }

        public void setMaxHeartsPerLine(int maxHeartsPerLine) {
            this.maxHeartsPerLine = maxHeartsPerLine;
        }

        public void setDisplayFluids(RayTraceContext.FluidMode displayFluids) {
            this.fluldMode = displayFluids;
        }

        public void setDisplayFluids(boolean displayFluids) {
            this.fluldMode = displayFluids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE;
        }

        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        public boolean shouldShiftForDetails() {
            return this.shiftForDetails;
        }

        public DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public boolean shouldHideFromDebug() {
            return this.hideFromDebug;
        }

        public boolean shouldShowItem() {
            return this.showItem;
        }

        public boolean shouldEnableTextToSpeech() {
            return this.enableTextToSpeech;
        }

        public int getMaxHealthForRender() {
            return this.maxHealthForRender;
        }

        public int getMaxHeartsPerLine() {
            return this.maxHeartsPerLine;
        }

        public boolean shouldDisplayFluids() {
            return this.fluldMode != RayTraceContext.FluidMode.NONE;
        }

        public RayTraceContext.FluidMode getDisplayFluids() {
            return this.fluldMode;
        }

        public float getReachDistance() {
            return this.reachDistance;
        }

        public void setReachDistance(float reachDistance) {
            this.reachDistance = MathHelper.func_76131_a((float)reachDistance, (float)0.0f, (float)20.0f);
        }
    }
}

