/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.RenderContext;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.gui.GuiOptions;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.overlay.WailaTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    protected static boolean hasLight;
    protected static boolean hasDepthTest;
    protected static boolean hasLight0;
    protected static boolean hasLight1;
    protected static boolean hasRescaleNormal;
    protected static boolean hasColorMaterial;
    protected static boolean depthMask;
    protected static int depthFunc;

    public static void renderOverlay() {
        if (WailaTickHandler.instance().tooltip == null) {
            return;
        }
        if (!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        if (Waila.CONFIG.get().getGeneral().getDisplayMode() == WailaConfig.DisplayMode.HOLD_KEY && !WailaClient.showOverlay.getKeyBinding().func_151470_d()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        if (RayTracing.INSTANCE.getTarget() == null) {
            return;
        }
        if (mc.field_71462_r != null) {
            double y;
            double x;
            if (!(mc.field_71462_r instanceof GuiOptions)) {
                return;
            }
            Rectangle position = WailaTickHandler.instance().tooltip.getPosition();
            if (position.contains(x = mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m(), y = mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n())) {
                return;
            }
        }
        if (mc.field_71456_v.func_175181_h().field_175254_k || mc.field_213279_p != null || !Minecraft.func_71382_s()) {
            return;
        }
        if (mc.field_71474_y.field_74330_P && Waila.CONFIG.get().getGeneral().shouldHideFromDebug()) {
            return;
        }
        if (RayTracing.INSTANCE.getTarget().func_216346_c() == RayTraceResult.Type.BLOCK) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip, new MatrixStack());
        }
        if (RayTracing.INSTANCE.getTarget().func_216346_c() == RayTraceResult.Type.ENTITY && PluginConfig.INSTANCE.get(PluginCore.CONFIG_SHOW_ENTITY)) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip, new MatrixStack());
        }
    }

    public static void enableGUIStandardItemLighting() {
        RenderSystem.pushMatrix();
        RenderSystem.rotatef((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)165.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_227780_a_();
        RenderSystem.popMatrix();
    }

    public static void renderOverlay(Tooltip tooltip, MatrixStack matrixStack) {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("Waila Overlay");
        RenderContext.matrixStack = matrixStack;
        matrixStack.func_227860_a_();
        OverlayRenderer.saveGLState();
        WailaRenderEvent.Pre preEvent = new WailaRenderEvent.Pre(DataAccessor.INSTANCE, tooltip.getPosition());
        if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
            OverlayRenderer.loadGLState();
            matrixStack.func_227865_b_();
            return;
        }
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        Rectangle position = preEvent.getPosition();
        WailaConfig.ConfigOverlay.ConfigOverlayColor color = Waila.CONFIG.get().getOverlay().getColor();
        if (color.getRawAlpha() > 0) {
            WailaRenderEvent.Color colorEvent = new WailaRenderEvent.Color(color.getAlpha(), color.getBackgroundColor(), color.getGradientStart(), color.getGradientEnd());
            MinecraftForge.EVENT_BUS.post((Event)colorEvent);
            OverlayRenderer.drawTooltipBox(matrixStack, position.x, position.y, position.width, position.height, colorEvent.getBackground(), colorEvent.getGradientStart(), colorEvent.getGradientEnd(), Waila.CONFIG.get().getOverlay().getSquare());
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        tooltip.draw();
        RenderSystem.disableBlend();
        if (tooltip.hasItem()) {
            OverlayRenderer.enableGUIStandardItemLighting();
        }
        RenderSystem.enableRescaleNormal();
        if (tooltip.hasItem()) {
            if (tooltip.identifierStack == null) {
                tooltip.identifierStack = RayTracing.INSTANCE.getIdentifierStack();
            }
            DisplayUtil.renderStack(matrixStack, position.x + 5, position.y + 2, tooltip.identifierStack, 1.0f);
        }
        WailaRenderEvent.Post postEvent = new WailaRenderEvent.Post(position);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        OverlayRenderer.loadGLState();
        RenderSystem.enableDepthTest();
        matrixStack.func_227865_b_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    public static void saveGLState() {
        hasLight = GL11.glGetBoolean((int)2896);
        hasLight0 = GL11.glGetBoolean((int)16384);
        hasLight1 = GL11.glGetBoolean((int)16385);
        hasDepthTest = GL11.glGetBoolean((int)2929);
        hasRescaleNormal = GL11.glGetBoolean((int)32826);
        hasColorMaterial = GL11.glGetBoolean((int)2903);
        depthFunc = GL11.glGetInteger((int)2932);
        depthMask = GL11.glGetBoolean((int)2930);
        GL11.glPushAttrib((int)1);
    }

    public static void loadGLState() {
        RenderSystem.depthMask((boolean)depthMask);
        RenderSystem.depthFunc((int)depthFunc);
        if (hasLight) {
            RenderSystem.enableLighting();
        } else {
            RenderSystem.disableLighting();
        }
        if (hasLight0) {
            GlStateManager.func_227638_a_((int)0);
        } else if (hasLight1) {
            GlStateManager.func_227638_a_((int)1);
        } else if (hasDepthTest) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        if (hasRescaleNormal) {
            RenderSystem.enableRescaleNormal();
        } else {
            RenderSystem.disableRescaleNormal();
        }
        if (hasColorMaterial) {
            RenderSystem.enableColorMaterial();
        } else {
            RenderSystem.disableColorMaterial();
        }
        RenderSystem.popAttributes();
    }

    public static void drawTooltipBox(MatrixStack matrixStack, int x, int y, int w, int h, int bg, int grad1, int grad2, boolean square) {
        DisplayUtil.drawGradientRect(matrixStack, x + 1, y + 1, w - 1, h - 1, bg, bg);
        if (!square) {
            DisplayUtil.drawGradientRect(matrixStack, x + 1, y, w - 1, 1, bg, bg);
            DisplayUtil.drawGradientRect(matrixStack, x + 1, y + h, w - 1, 1, bg, bg);
            DisplayUtil.drawGradientRect(matrixStack, x, y + 1, 1, h - 1, bg, bg);
            DisplayUtil.drawGradientRect(matrixStack, x + w, y + 1, 1, h - 1, bg, bg);
        }
        DisplayUtil.drawGradientRect(matrixStack, x + 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(matrixStack, x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(matrixStack, x + 1, y + 1, w - 1, 1, grad1, grad1);
        DisplayUtil.drawGradientRect(matrixStack, x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }
}

