/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class RayTracing {
    public static final RayTracing INSTANCE = new RayTracing();
    private RayTraceResult target = null;
    private Minecraft mc = Minecraft.func_71410_x();

    private RayTracing() {
    }

    public void fire() {
        Entity targetEntity;
        Entity viewpoint = this.mc.func_175606_aa();
        if (viewpoint == null) {
            return;
        }
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.func_216346_c() == RayTraceResult.Type.ENTITY && this.canBeTarget(targetEntity = ((EntityRayTraceResult)this.mc.field_71476_x).func_216348_a(), viewpoint)) {
            this.target = this.mc.field_71476_x;
            return;
        }
        float reach = this.mc.field_71442_b.func_78757_d() + Waila.CONFIG.get().getGeneral().getReachDistance();
        this.target = this.rayTrace(viewpoint, reach, this.mc.func_184121_ak());
    }

    public RayTraceResult getTarget() {
        return this.target;
    }

    public ItemStack getTargetStack() {
        return this.target != null && this.target.func_216346_c() == RayTraceResult.Type.BLOCK ? this.getIdentifierStack() : ItemStack.field_190927_a;
    }

    public Entity getTargetEntity() {
        return this.target.func_216346_c() == RayTraceResult.Type.ENTITY ? this.getIdentifierEntity() : null;
    }

    public RayTraceResult rayTrace(Entity entity, double playerReach, float partialTicks) {
        double blockDist;
        double entityDist;
        Vector3d traceEnd;
        Vector3d eyePosition = entity.func_174824_e(partialTicks);
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
            traceEnd = this.mc.field_71476_x.func_216347_e();
        } else {
            Vector3d lookVector = entity.func_70676_i(partialTicks);
            traceEnd = eyePosition.func_72441_c(lookVector.field_72450_a * playerReach, lookVector.field_72448_b * playerReach, lookVector.field_72449_c * playerReach);
        }
        World world = entity.func_130014_f_();
        AxisAlignedBB bound = new AxisAlignedBB(eyePosition, traceEnd);
        Predicate<Entity> predicate = e -> this.canBeTarget((Entity)e, entity);
        EntityRayTraceResult entityResult = RayTracing.rayTraceEntities(world, entity, eyePosition, traceEnd, bound, predicate);
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Vector3d lookVector = entity.func_70676_i(partialTicks);
            traceEnd = eyePosition.func_72441_c(lookVector.field_72450_a * playerReach, lookVector.field_72448_b * playerReach, lookVector.field_72449_c * playerReach);
        }
        RayTraceContext.FluidMode fluidView = Waila.CONFIG.get().getGeneral().getDisplayFluids();
        RayTraceContext context = new RayTraceContext(eyePosition, traceEnd, RayTraceContext.BlockMode.OUTLINE, fluidView, entity);
        BlockRayTraceResult blockResult = world.func_217299_a(context);
        if (entityResult != null && blockResult != null && blockResult.func_216346_c() == RayTraceResult.Type.BLOCK && (entityDist = entityResult.func_216347_e().func_72436_e(eyePosition)) < (blockDist = blockResult.func_216347_e().func_72436_e(eyePosition))) {
            return entityResult;
        }
        return blockResult;
    }

    public ItemStack getIdentifierStack() {
        List<ItemStack> items = this.getIdentifierItems();
        if (items.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return items.get(0);
    }

    private boolean canBeTarget(Entity target, Entity viewEntity) {
        if (target.func_175149_v()) {
            return false;
        }
        if (target == viewEntity.func_184187_bx()) {
            return false;
        }
        return !(viewEntity instanceof PlayerEntity ? target.func_98034_c((PlayerEntity)viewEntity) : target.func_82150_aj());
    }

    @Nullable
    public static EntityRayTraceResult rayTraceEntities(World worldIn, Entity projectile, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : worldIn.func_175674_a(projectile, boundingBox, filter)) {
            double d1;
            Optional optional;
            if (entity1.func_175149_v()) continue;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ();
            if (axisalignedbb.func_72320_b() < 0.3) {
                axisalignedbb = axisalignedbb.func_186662_g(0.3);
            }
            if (!(optional = axisalignedbb.func_216365_b(startVec, endVec)).isPresent() || !((d1 = startVec.func_72436_e((Vector3d)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    public Entity getIdentifierEntity() {
        if (this.target == null || this.target.func_216346_c() != RayTraceResult.Type.ENTITY) {
            return null;
        }
        ArrayList entities = Lists.newArrayList();
        Entity entity = ((EntityRayTraceResult)this.target).func_216348_a();
        if (WailaRegistrar.INSTANCE.hasOverrideEntityProviders(entity)) {
            Collection<List<IEntityComponentProvider>> overrideProviders = WailaRegistrar.INSTANCE.getOverrideEntityProviders(entity).values();
            for (List<IEntityComponentProvider> providers : overrideProviders) {
                for (IEntityComponentProvider provider : providers) {
                    entities.add(provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE));
                }
            }
        }
        return entities.size() > 0 ? (Entity)entities.get(0) : entity;
    }

    public List<ItemStack> getIdentifierItems() {
        ArrayList items = Lists.newArrayList();
        if (this.target == null) {
            return items;
        }
        switch (this.target.func_216346_c()) {
            case ENTITY: {
                if (!WailaRegistrar.INSTANCE.hasStackEntityProviders(((EntityRayTraceResult)this.target).func_216348_a())) break;
                Collection<List<IEntityComponentProvider>> providers = WailaRegistrar.INSTANCE.getStackEntityProviders(((EntityRayTraceResult)this.target).func_216348_a()).values();
                for (List<IEntityComponentProvider> providersList : providers) {
                    for (IEntityComponentProvider provider : providersList) {
                        ItemStack providerStack = provider.getDisplayItem(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
                        if (providerStack.func_190926_b()) continue;
                        items.add(providerStack);
                    }
                }
                break;
            }
            case BLOCK: {
                ClientWorld world = this.mc.field_71441_e;
                BlockPos pos = ((BlockRayTraceResult)this.target).func_216350_a();
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c().isAir(state, (IBlockReader)world, pos)) {
                    return items;
                }
                TileEntity tile = world.func_175625_s(pos);
                if (WailaRegistrar.INSTANCE.hasStackProviders(state.func_177230_c())) {
                    this.handleStackProviders(items, WailaRegistrar.INSTANCE.getStackProviders(state.func_177230_c()).values());
                }
                if (tile != null && WailaRegistrar.INSTANCE.hasStackProviders(tile)) {
                    this.handleStackProviders(items, WailaRegistrar.INSTANCE.getStackProviders(tile).values());
                }
                if (!items.isEmpty()) {
                    return items;
                }
                ItemStack pick = state.func_177230_c().getPickBlock(state, this.target, (IBlockReader)world, pos, (PlayerEntity)this.mc.field_71439_g);
                if (!pick.func_190926_b()) {
                    return Collections.singletonList(pick);
                }
                if (state.func_177230_c().func_199767_j() != Items.field_190931_a) {
                    return Collections.singletonList(new ItemStack((IItemProvider)state.func_177230_c()));
                }
                if (!(state.func_177230_c() instanceof FlowingFluidBlock)) break;
                FlowingFluidBlock block = (FlowingFluidBlock)state.func_177230_c();
                FlowingFluid fluid = block.getFluid();
                return Collections.singletonList(FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)fluid, 1)));
            }
        }
        return items;
    }

    private void handleStackProviders(List<ItemStack> items, Collection<List<IComponentProvider>> providers) {
        for (List<IComponentProvider> providersList : providers) {
            for (IComponentProvider provider : providersList) {
                ItemStack providerStack = provider.getStack(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
                if (providerStack.func_190926_b()) continue;
                items.add(providerStack);
            }
        }
    }
}

