/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay.tooltiprenderers;

import java.awt.Dimension;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.RenderContext;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.IconUI;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;

public class TooltipRendererArmor
implements ITooltipRenderer {
    @Override
    public Dimension getSize(CompoundNBT tag, ICommonAccessor accessor) {
        float maxHearts;
        float maxHealth = maxHearts = (float)Waila.CONFIG.get().getGeneral().getMaxHeartsPerLine();
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int lineCount = (int)Math.ceil(maxHealth / maxHearts);
        return new Dimension(8 * heartsPerLine, 10 * lineCount);
    }

    @Override
    public void draw(CompoundNBT tag, ICommonAccessor accessor, int x, int y) {
        float maxHearts = Waila.CONFIG.get().getGeneral().getMaxHeartsPerLine();
        float health = tag.func_74760_g("armor");
        if (health == -1.0f) {
            health = 1.0f;
            maxHearts = 1.0f;
        }
        float maxHealth = maxHearts;
        int heartCount = MathHelper.func_76123_f((float)maxHealth);
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int xOffset = 0;
        for (int i = 1; i <= heartCount; ++i) {
            if (i <= MathHelper.func_76141_d((float)health)) {
                DisplayUtil.renderIcon(RenderContext.matrixStack, x + xOffset, y, 8, 8, IconUI.ARMOR);
                xOffset += 8;
            }
            if ((float)i > health && (float)i < health + 1.0f) {
                DisplayUtil.renderIcon(RenderContext.matrixStack, x + xOffset, y, 8, 8, IconUI.HALF_ARMOR);
                xOffset += 8;
            }
            if ((float)i >= health + 1.0f) {
                DisplayUtil.renderIcon(RenderContext.matrixStack, x + xOffset, y, 8, 8, IconUI.EMPTY_ARMOR);
                xOffset += 8;
            }
            if (i % heartsPerLine != 0) continue;
            y += 10;
            xOffset = 0;
        }
    }
}

