/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.HUDHandlerBlocks;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.lang3.StringUtils;
import snownee.jade.JadePlugin;
import snownee.jade.Renderables;

public class HarvestToolProvider
implements IComponentProvider,
ISelectiveResourceReloadListener {
    public static final HarvestToolProvider INSTANCE = new HarvestToolProvider();
    public static final Cache<TestCase, String> toolNames = CacheBuilder.newBuilder().build();
    public static final Cache<BlockState, TestCase> resultCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final List<TestCase> testTools = Lists.newLinkedList();
    public static final Map<ToolType, TestCase> toolTypeMap = Maps.newHashMap();
    public static final TestCase NO_TOOL = new TestCase(ItemStack.field_190927_a, "no_tool", null);
    public static final TestCase UNBREAKABLE = new TestCase(ItemStack.field_190927_a, "unbreakable", null);
    private static final ITextComponent UNBREAKABLE_TEXT = new TranslationTextComponent("jade.harvest_tool.unbreakable").func_240699_a_(TextFormatting.DARK_RED);

    public static String getToolName(TestCase testCase) {
        try {
            return (String)toolNames.get((Object)testCase, () -> {
                if (I18n.func_188566_a((String)("jade.harvest_tool." + testCase.name))) {
                    return I18n.func_135052_a((String)("jade.harvest_tool." + testCase.name), (Object[])new Object[0]);
                }
                return StringUtils.capitalize((String)testCase.name);
            });
        }
        catch (ExecutionException e) {
            Waila.LOGGER.catching((Throwable)e);
            return testCase.name;
        }
    }

    @Nullable
    public static TestCase getTool(BlockState state, World world, BlockPos pos) {
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (hardness < 0.0f) {
            return UNBREAKABLE;
        }
        ToolType toolType = state.getHarvestTool();
        if (toolType != null) {
            TestCase testCase = toolTypeMap.get(toolType);
            if (testCase == null) {
                testCase = new TestCase(ItemStack.field_190927_a, toolType.getName(), toolType);
                toolTypeMap.put(toolType, testCase);
            }
            return testCase;
        }
        if (state.func_235783_q_()) {
            for (TestCase testCase : testTools) {
                if (testCase.stack.func_190926_b() || !testCase.stack.func_150998_b(state)) continue;
                return testCase;
            }
        }
        return NO_TOOL;
    }

    public static synchronized TestCase registerTool(ItemStack stack, String name, @Nullable ToolType toolType) {
        TestCase testCase = new TestCase(stack, name, toolType);
        testTools.add(testCase);
        if (toolType != null) {
            toolTypeMap.put(toolType, testCase);
        }
        return testCase;
    }

    @Override
    public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        PlayerEntity player = accessor.getPlayer();
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        if (config.get(JadePlugin.HARVEST_TOOL_NEW_LINE)) {
            return;
        }
        ITextComponent text = this.getText(accessor, config);
        if (text == null || text == UNBREAKABLE_TEXT) {
            return;
        }
        ITaggableList taggableList = (ITaggableList)tooltip;
        ITextComponent component = (ITextComponent)taggableList.getTag(HUDHandlerBlocks.OBJECT_NAME_TAG);
        if (component != null) {
            taggableList.setTag(HUDHandlerBlocks.OBJECT_NAME_TAG, Renderables.of(component, text));
        }
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        PlayerEntity player = accessor.getPlayer();
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        ITextComponent text = this.getText(accessor, config);
        if (text != UNBREAKABLE_TEXT) {
            if (!config.get(JadePlugin.HARVEST_TOOL_NEW_LINE)) {
                return;
            }
            if (text == null) {
                return;
            }
        }
        tooltip.add(0, text);
    }

    public ITextComponent getText(IDataAccessor accessor, IPluginConfig config) {
        int offsetY;
        String sub;
        if (!config.get(JadePlugin.HARVEST_TOOL)) {
            return null;
        }
        BlockState state = accessor.getBlockState();
        TestCase testCase = NO_TOOL;
        resultCache.invalidateAll();
        try {
            testCase = (TestCase)resultCache.get((Object)state, () -> HarvestToolProvider.getTool(state, accessor.getWorld(), accessor.getPosition()));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (testCase == UNBREAKABLE) {
            return UNBREAKABLE_TEXT;
        }
        if (testCase == NO_TOOL) {
            return null;
        }
        if (!state.func_235783_q_() && !config.get(JadePlugin.EFFECTIVE_TOOL)) {
            return null;
        }
        int level = state.getHarvestLevel();
        String name = "";
        ItemStack tool = (ItemStack)testCase.toolMap.get(level);
        if (tool == null) {
            tool = testCase.stack;
            if (level > 0) {
                name = " " + level;
            }
        }
        boolean canHarvest = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)accessor.getPlayer(), (IBlockReader)accessor.getWorld(), (BlockPos)accessor.getPosition());
        if (state.func_235783_q_()) {
            sub = canHarvest ? "\u00a7a\u2714" : "\u00a74\u2715";
        } else {
            ItemStack held = accessor.getPlayer().func_184614_ca();
            sub = canHarvest && ForgeHooks.isToolEffective((IWorldReader)accessor.getWorld(), (BlockPos)accessor.getPosition(), (ItemStack)held) ? "\u00a7a\u2714" : "";
        }
        int n = offsetY = config.get(JadePlugin.HARVEST_TOOL_NEW_LINE) ? 0 : -3;
        if (name.isEmpty()) {
            return Renderables.of(new ITextComponent[]{Renderables.item(tool, 0.75f, offsetY), Renderables.sub(sub)});
        }
        return Renderables.of(new ITextComponent[]{Renderables.item(tool, 0.75f, offsetY), Renderables.sub(sub), Renderables.offsetText(name, 3, offsetY + 3)});
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.LANGUAGES)) {
            toolNames.invalidateAll();
            resultCache.invalidateAll();
        }
    }

    public static void init() {
        NonNullList stacks = NonNullList.func_191196_a();
        HashSet newToolTypes = Sets.newHashSet();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            item.func_150895_a(ItemGroup.field_78027_g, stacks);
        }
        for (ItemStack stack : stacks) {
            for (ToolType toolType : stack.getToolTypes()) {
                if (newToolTypes.contains(toolType)) {
                    toolTypeMap.get(toolType).addTool(stack);
                    continue;
                }
                if (toolTypeMap.containsKey(toolType)) continue;
                HarvestToolProvider.registerTool(ItemStack.field_190927_a, toolType.getName(), toolType).addTool(stack);
                newToolTypes.add(toolType);
            }
        }
    }

    static {
        HarvestToolProvider.registerTool(new ItemStack((IItemProvider)Items.field_151039_o), "pickaxe", ToolType.PICKAXE).addTool(Items.field_151050_s).addTool(Items.field_151035_b).addTool(Items.field_151046_w).addTool(Items.field_234756_kK_);
        HarvestToolProvider.registerTool(new ItemStack((IItemProvider)Items.field_151053_p), "axe", ToolType.AXE).addTool(Items.field_151049_t).addTool(Items.field_151036_c);
        HarvestToolProvider.registerTool(new ItemStack((IItemProvider)Items.field_151038_n), "shovel", ToolType.SHOVEL).addTool(Items.field_151051_r).addTool(Items.field_151037_a);
        HarvestToolProvider.registerTool(new ItemStack((IItemProvider)Items.field_151017_I), "hoe", ToolType.HOE).addTool(Items.field_151018_J).addTool(Items.field_151019_K);
        HarvestToolProvider.registerTool(new ItemStack((IItemProvider)Items.field_151097_aZ), "shears", null);
    }

    public static class TestCase {
        private ItemStack stack;
        private final String name;
        private final ToolType toolType;
        private final Int2ObjectMap<ItemStack> toolMap = new Int2ObjectOpenHashMap();

        public TestCase(ItemStack stack, String name, @Nullable ToolType toolType) {
            this.stack = stack;
            this.name = name;
            this.toolType = toolType;
            this.addTool(stack);
        }

        public TestCase addTool(Item tool) {
            return this.addTool(new ItemStack((IItemProvider)tool));
        }

        public TestCase addTool(ItemStack stack) {
            ItemStack oldTool;
            if (stack.func_190926_b()) {
                return this;
            }
            int level = 0;
            if (this.toolType != null) {
                level = stack.getHarvestLevel(this.toolType, null, null);
            }
            if (this.stack.func_190926_b() || level == 0) {
                this.stack = stack;
            }
            if ((oldTool = (ItemStack)this.toolMap.get(level)) != null) {
                IItemTier tier = null;
                if (oldTool.func_77973_b() instanceof TieredItem) {
                    tier = ((TieredItem)oldTool.func_77973_b()).func_200891_e();
                }
                if (tier != ItemTier.GOLD) {
                    return this;
                }
            }
            this.toolMap.put(level, (Object)stack);
            return this;
        }
    }
}

